<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/userguide3/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/
$route['default_controller'] = 'login';
$route['404_override'] = '';
$route['translate_uri_dashes'] = FALSE;
$route['karyawan/edit/(:num)'] = 'karyawan/edit/$1';
$route['karyawan/update'] = 'karyawan/update';
$route['mold/edit/(:num)'] = 'mold/edit/$1';
$route['summery-molding'] = 'Summery_molding/summery_mold';
$route['piket-daily']        = 'PiketDaily/index';
$route['piket-daily/create'] = 'PiketDaily/create';
$route['piket-daily/store']  = 'PiketDaily/store';

$route['piket-daily/edit/(:num)']        = 'PiketDaily/edit/$1';
$route['piket-daily/save-line']          = 'PiketDaily/save_line';       // POST (AJAX)
$route['piket-daily/update-header/(:num)']= 'PiketDaily/update_header/$1';// POST
$route['piket-daily/upload-line-photos'] = 'PiketDaily/upload_line_photos';
$route['piket-daily/delete-photo']       = 'PiketDaily/delete_photo';
$route['piket-daily/upload-photos'] = 'PiketDaily/upload_photos';


$route['piket-daily/print/(:num)'] = 'PiketDaily/print/$1';

$route['piket-daily/sign/(:num)']       = 'PiketDaily/sign/$1';
$route['piket-daily/sign/save']         = 'PiketDaily/sign_save';
$route['piket-daily/sign/status/(:num)']= 'PiketDaily/sign_status/$1';

$route['piket-daily/sign_pad/(:num)/(:any)'] = 'PiketDaily/sign_pad/$1/$2';
$route['piket-daily/sign_submit']           = 'PiketDaily/sign_submit';
$route['piket-daily/signature_status/(:num)'] = 'PiketDaily/signature_status/$1';
// explicit routes for safety
$route['piket-daily/delete/(:num)']  = 'PiketDaily/destroy/$1';
$route['piket-daily/destroy/(:num)'] = 'PiketDaily/destroy/$1';



