<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Karyawan extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Model_karyawan');
        $this->load->helper(['url','form']);
        $this->load->library(['session','form_validation']);

        // Guard login
        if (!$this->session->userdata('nama')) {
            redirect('login');
        }
    }

    /* ---------- Template renderer ---------- */
    private function render($view, $data = [])
    {
        $this->load->view('templates/header', $data);      // <head>, open #wrapper
        $this->load->view('templates/sidebar', $data);     // sidebar
        $this->load->view('templates/content_start', $data); // topbar + open container-fluid
        $this->load->view($view, $data);                   // pure content
        $this->load->view('templates/footer');             // close container + wrappers + scripts
    }

    /* ---------- List ---------- */
    public function index()
    {
        $data = [
            'title'    => 'Data Karyawan',
            'karyawan' => $this->Model_karyawan->get(),
        ];
        $this->render('karyawan/karyawan', $data);
    }

    /* ---------- Form Tambah ---------- */
    public function tambah()
    {
        $data['title'] = 'Tambah Karyawan';
        $this->render('karyawan/tambah_data_karyawan', $data);
    }

    /* ---------- Action Tambah ---------- */
    public function tambah_action()
    {
        // Validasi sederhana (opsional, bisa kamu tambah rule lagi)
        $this->form_validation->set_rules('nama','Nama','required|trim');
        $this->form_validation->set_rules('nik','NIK','required|trim');
        $this->form_validation->set_rules('dept','Dept','required|trim');
        $this->form_validation->set_rules('bagian','Bagian','required|trim');

        if (!$this->form_validation->run()) {
            return $this->tambah();
        }

        $data = [
            'nama'   => $this->input->post('nama', true),
            'nik'    => $this->input->post('nik', true),
            'dept'   => $this->input->post('dept', true),
            'bagian' => $this->input->post('bagian', true),
        ];

        $ok = $this->Model_karyawan->tambah_data($data);
        $this->session->set_flashdata($ok ? 'scan_success' : 'scan_error',
            $ok ? 'Data karyawan berhasil ditambahkan' : 'Gagal menambahkan data karyawan');

        redirect('karyawan');
    }

    /* ---------- Delete ---------- */
    public function delete($id)
    {
        $row = $this->Model_karyawan->get_karyawan($id);
        if ($row) {
            $ok = $this->Model_karyawan->delete_karyawan($id);
            $this->session->set_flashdata($ok ? 'scan_success' : 'scan_error',
                $ok ? 'Data karyawan berhasil dihapus' : 'Gagal menghapus data karyawan');
        } else {
            $this->session->set_flashdata('scan_error', 'Data karyawan tidak ditemukan');
        }
        redirect('karyawan');
    }

    /* ---------- Form Edit ---------- */
    public function edit($id)
    {
        $row = $this->Model_karyawan->get_by_id($id);
        if (!$row) show_404();

        $data = [
            'title'    => 'Edit Karyawan',
            'karyawan' => $row,
        ];
        $this->render('karyawan/edit_karyawan', $data);
    }

    /* ---------- Action Update ---------- */
    public function update()
    {
        $id = $this->input->post('id');
        if (!$id) show_error('ID tidak ditemukan', 400);

        $this->form_validation->set_rules('nama','Nama','required|trim');
        $this->form_validation->set_rules('nik','NIK','required|trim');
        $this->form_validation->set_rules('dept','Dept','required|trim');
        $this->form_validation->set_rules('bagian','Bagian','required|trim');

        if (!$this->form_validation->run()) {
            return $this->edit($id);
        }

        $data = [
            'nama'   => $this->input->post('nama', true),
            'nik'    => $this->input->post('nik', true),
            'dept'   => $this->input->post('dept', true),
            'bagian' => $this->input->post('bagian', true),
        ];

        $ok = $this->Model_karyawan->update($id, $data);
        $this->session->set_flashdata($ok ? 'scan_success' : 'scan_error',
            $ok ? 'Data karyawan berhasil diperbarui' : 'Gagal memperbarui data karyawan');

        redirect('karyawan');
    }
}
