<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Login extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('Model_user');
        $this->load->helper(['url', 'form']);
        $this->load->library('session');
    }

    public function index()
    {
        $this->load->view('login');
    }

    public function registration()
    {
        $this->load->view('registration');
    }

    public function add_user()
    {
        $password = (string)$this->input->post('password');
        $hash     = password_hash($password, PASSWORD_DEFAULT);

        $data = [
            'username' => $this->input->post('username', true),
            'password' => $password,   // dipakai hanya untuk kemudahan, hash tetap utama
            'hash'     => $hash,
            'role'     => $this->input->post('role', true),
        ];

        $this->Model_user->insert_user($data);
        redirect('login');
    }

    public function login_action()
{
    // DEBUG FLAG: aktif kalau ENV development + ada ?dbg=1 di URL
    $debug = (defined('ENVIRONMENT') && ENVIRONMENT === 'development'
              && $this->input->get('dbg') === '1');

    if ($debug) {
        echo "<pre>DEBUG LOGIN_ACTION\n";
        echo "REQUEST URI : " . ($this->input->server('REQUEST_URI') ?? '') . "\n\n";
        echo "STEP 0 - \$_POST:\n";
        print_r($_POST);
        echo "\n----------------------------------------\n";
    }

    $username = trim((string)$this->input->post('username'));
    $password = (string)$this->input->post('password');

    if ($debug) {
        echo "STEP 1 - Parsed Input:\n";
        echo "username = {$username}\n";
        echo "password length = " . strlen($password) . "\n";
        echo "----------------------------------------\n";
    }

    if ($username === '' || $password === '') {
        if ($debug) {
            echo "STOP: Username / password kosong\n";
            echo "</pre>";
            exit;
        }

        $this->session->set_flashdata('pesan', 'Username / password wajib diisi!');
        redirect('login');
        return;
    }

    $data = $this->Model_user->cek($username);

    if ($debug) {
        echo "STEP 2 - Hasil Model_user->cek({$username}):\n";
        var_dump($data);
        echo "\n----------------------------------------\n";
    }

    if (!$data) {
        if ($debug) {
            echo "STOP: User tidak ditemukan di database\n";
            echo "</pre>";
            exit;
        }

        $this->session->set_flashdata('pesan', 'Username atau password salah!');
        redirect('login');
        return;
    }

    // cek password (utama: hash, fallback: kolom password biasa)
    $passOk = false;
    if (!empty($data->hash)) {
        $passOk = password_verify($password, $data->hash);
        if ($debug) {
            echo "STEP 3 - Password verify via HASH\n";
            echo "hash in DB : {$data->hash}\n";
            echo "passOk      : " . ($passOk ? 'TRUE' : 'FALSE') . "\n";
            echo "----------------------------------------\n";
        }
    } else {
        $passOk = ($password === $data->password);
        if ($debug) {
            echo "STEP 3 - Password compare PLAIN\n";
            echo "db password : {$data->password}\n";
            echo "passOk      : " . ($passOk ? 'TRUE' : 'FALSE') . "\n";
            echo "----------------------------------------\n";
        }
    }

    if (!$passOk) {
        if ($debug) {
            echo "STOP: Password tidak cocok\n";
            echo "</pre>";
            exit;
        }

        $this->session->set_flashdata('pesan', 'Username atau password salah!');
        redirect('login');
        return;
    }

    // set data session
    $sessionData = [
        'user_id'  => (int)$data->id,
        'username' => $data->username,
        'nama'     => $data->nama ?: $data->username,
        'role'     => strtolower($data->role),   // admin, user, check, confirmed, approval
    ];
    $this->session->set_userdata($sessionData);

    if ($debug) {
        echo "STEP 4 - Session Data yang akan diset:\n";
        print_r($sessionData);
        echo "----------------------------------------\n";
    }

    // AFTER LOGIN REDIRECT
    $redirectTarget = $this->session->userdata('after_login_redirect');
    if (!empty($redirectTarget)) {

        if ($debug) {
            echo "STEP 5 - Redirect ke after_login_redirect:\n";
            echo $redirectTarget . "\n";
            echo "</pre>";
            exit;
        }

        $this->session->unset_userdata('after_login_redirect');
        redirect($redirectTarget);
        return;
    }

    if ($debug) {
        echo "STEP 5 - Redirect default ke 'piket-daily'\n";
        echo "</pre>";
        exit;
    }

    // kalau tidak ada target khusus, lempar ke halaman utama
    redirect('piket-daily');
}


    // logout
    public function logout()
    {
        $this->session->sess_destroy();
        redirect('login');
    }
}
