<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Reader\Xlsx;
use PhpOffice\PhpSpreadsheet\Shared\Date;
use Dompdf\Dompdf;
use Dompdf\Options;

class Mold extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('Model_mold');
        $this->load->library(['form_validation', 'session']);
        $this->load->helper(['form', 'url']);
        
        if (!isset($_SESSION['nama'])){
            session_start();
            $this->session->set_flashdata('message', 'Anda harus login dulu!');
            redirect('login');}
    }

    private function _load_view($view, $data = [])
    {
       // $data['title'] bisa di-set dari caller
        $this->load->view('templates/header', $data);
        $this->load->view('templates/sidebar', $data);
        $this->load->view('templates/content_start', $data); // topbar + container-fluid
        $this->load->view($view, $data);                     // konten murni
        $this->load->view('templates/footer');               // tutup container + wrapper

    }

    public function index()
    {
        $filters = [
            'part_number'  => $this->input->get('part_number'),
            'customer'     => $this->input->get('customer'),
            'machine_type' => $this->input->get('machine_type'),
            'tgl_awal'     => $this->input->get('tgl_awal'),
            'tgl_akhir'    => $this->input->get('tgl_akhir'),
        ];

        $data['mold'] = $this->Model_mold->get_filtered($filters);
        $data['machine_types'] = $this->Model_mold->get_unique_machine_types();

        $this->_load_view('mold/mold', $data);
    }

    public function tambah()
    {
       $this->load->view('templates/header');
       $this->load->view('mold/form_tambah');
    }

    public function simpan() {
    if (!$this->_validate()) {
        $this->tambah();
        return;
    }

    $data = $this->_input_data();
    $data['last_update'] = date('Y-m-d H:i:s');
    $data['created_by']  = $this->session->userdata('nama');

    // Ambil ID dari form (kalau ada)
    $id = $this->input->post('id');

    if (empty($id)) {
        // INSERT — boleh part_number sama
        $data['data_stock'] = $data['qty'];
        if ($this->Model_mold->insert($data)) {
            $this->session->set_flashdata('success', 'Data berhasil disimpan!');
        } else {
            $this->session->set_flashdata('error', 'Gagal menyimpan data!');
        }
    } else {
        // UPDATE — update berdasarkan ID saja
        unset($data['data_stock']); // Jangan ubah stock
        if ($this->Model_mold->update($id, $data)) {
            $this->session->set_flashdata('success', 'Data berhasil diupdate!');
        } else {
            $this->session->set_flashdata('error', 'Gagal mengupdate data!');
        }
    }

    redirect('mold');
     }

    public function edit($id)
    {
        $data['mold'] = $this->Model_mold->get_by_id($id);
        if (!$data['mold']) {
            show_404();
        }
        $this->load->view('templates/header');
        $this->load->view('mold/form_edit', $data);
    }

   public function update()
{
    if (!$this->_validate()) {
        $this->edit($this->input->post('id'));
        return;
    }

    $id = $this->input->post('id');
    if (!$id) {
        echo "ID tidak ditemukan di POST!";
        exit;
    }

    $data = $this->_input_data();
    $data['last_update'] = date('Y-m-d H:i:s');
    $data['data_stock'] = $data['qty'];

    $updated = $this->Model_mold->update($id, $data);
    if ($updated) {
        $this->session->set_flashdata('success', 'Data berhasil diperbarui!');
    } else {
        $this->session->set_flashdata('error', 'Gagal mengupdate data!');
    }

    redirect('mold');
}

    public function delete($id)
    {
        $this->Model_mold->delete($id);
        $this->session->set_flashdata('success', 'Data berhasil dihapus!');
        redirect('mold');
    }

    public function upload_excel()
    {
        ini_set('max_execution_time', 600);
        ini_set('memory_limit', '1G');

        if (!isset($_FILES['file_excel']['name']) || $_FILES['file_excel']['error'] != 0) {
            $this->session->set_flashdata('error', 'Gagal upload file!');
            redirect('mold');
        }

        $file_tmp = $_FILES['file_excel']['tmp_name'];

        $reader = new Xlsx();
        $reader->setReadDataOnly(true);

        try {
            $spreadsheet = $reader->load($file_tmp);
        } catch (\Exception $e) {
            $this->session->set_flashdata('error', 'Gagal membaca file Excel: ' . $e->getMessage());
            redirect('mold');
        }

        $rows = $spreadsheet->getActiveSheet()->toArray();
        $data = [];

        for ($i = 1; $i < count($rows); $i++) {
            $row = $rows[$i];
            if (empty(array_filter($row))) continue;

            $data[] = [
                'date'           => is_numeric($row[1]) ? Date::excelToDateTimeObject($row[1])->format('Y-m-d') : date('Y-m-d', strtotime($row[1] ?? 'now')),
                'part_number'    => $row[2] ?? '',
                'part_name'      => $row[3] ?? '',
                'material_code'  => $row[4] ?? '',
                'customer'       => $row[5] ?? '',
                'machine_type'   => $row[6] ?? '',
                'qty'            => (int)($row[7] ?? 0),
                'status'         => $row[8] ?? '',
                'pic_distribusi' => $row[9] ?? '',
                'pic_penerima'   => $row[10] ?? '',
                'data_stock'     => (int)($row[7] ?? 0), // Set data_stock = qty
                'data_erp'       => $row[12] ?? '',
                'created_by'     => $this->session->userdata('nama'),
                'last_update'    => date('Y-m-d H:i:s'),
            ];
        }

        if (!empty($data)) {
            $this->Model_mold->insert_batch($data);
            $this->session->set_flashdata('success', 'Berhasil mengimpor data Excel.');
        } else {
            $this->session->set_flashdata('error', 'Tidak ada data valid untuk disimpan.');
        }

        redirect('mold');
    }

    public function download_excel(){
    // Ambil filter dari GET request
    $filters = [
        'part_number'  => $this->input->get('part_number'),
        'customer'     => $this->input->get('customer'),
        'machine_type' => $this->input->get('machine_type'),
        'tgl_awal'     => $this->input->get('tgl_awal'),
        'tgl_akhir'    => $this->input->get('tgl_akhir'),
    ];

    // Ambil data dari model pakai filter
    $moldData = $this->Model_mold->get_filtered($filters);

    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();

    // Header kolom
    $headers = [
        'A1' => 'Date',
        'B1' => 'Part Number',
        'C1' => 'Part Name',
        'D1' => 'Material Code',
        'E1' => 'Customer',
        'F1' => 'Machine Type',
        'G1' => 'Qty',
        'H1' => 'Status',
        'I1' => 'PIC Distribusi',
        'J1' => 'PIC Penerima',
        'K1' => 'Data ERP',
        'L1' => 'Data Stock',
    ];

    foreach ($headers as $cell => $value) {
        $sheet->setCellValue($cell, $value);
    }

    // Isi data mulai dari baris ke-2
    $rowIndex = 2;
    foreach ($moldData as $row) {
        $sheet->setCellValue("A$rowIndex", $row->date);
        $sheet->setCellValue("B$rowIndex", $row->part_number);
        $sheet->setCellValue("C$rowIndex", $row->part_name);
        $sheet->setCellValue("D$rowIndex", $row->material_code);
        $sheet->setCellValue("E$rowIndex", $row->customer);
        $sheet->setCellValue("F$rowIndex", $row->machine_type);
        $sheet->setCellValue("G$rowIndex", $row->qty);
        $sheet->setCellValue("H$rowIndex", $row->status);
        $sheet->setCellValue("I$rowIndex", $row->pic_distribusi);
        $sheet->setCellValue("J$rowIndex", $row->pic_penerima);
        $sheet->setCellValue("K$rowIndex", $row->data_erp);
        $sheet->setCellValue("L$rowIndex", $row->data_stock);
        $rowIndex++;
    }

    // Output file Excel ke browser
    $filename = "filtered_mold_" . date('Ymd_His') . ".xlsx";
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("Content-Disposition: attachment; filename=\"$filename\"");
    header('Cache-Control: max-age=0');

    $writer = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($spreadsheet);
    $writer->save('php://output');
    exit;
}

    private function _validate()
    {
        $this->form_validation->set_rules('date', 'Date', 'required');
        $this->form_validation->set_rules('part_number', 'Part Number', 'required|trim');
        $this->form_validation->set_rules('part_name', 'Part Name', 'required|trim');
        $this->form_validation->set_rules('material_code', 'Material Code', 'required|trim');
        $this->form_validation->set_rules('customer', 'Customer', 'required|trim');
        $this->form_validation->set_rules('machine_type', 'Machine Type', 'required|trim');
        $this->form_validation->set_rules('qty', 'Quantity', 'required|integer');
        $this->form_validation->set_rules('status', 'Status', 'required|trim');
        return $this->form_validation->run();
    }

    private function _input_data()
    {
        return $this->input->post([
            'date', 'part_number', 'part_name', 'material_code',
            'customer', 'machine_type', 'qty','cavity','status',
            'pic_distribusi', 'pic_penerima', 'data_erp', 'data_stock'
        ], true);
    }

    public function sync_data_stock() {
    // Hanya boleh diakses via CLI atau admin
    if (!$this->input->is_cli_request() && $this->session->userdata('role') != 'admin') {
        show_error('Akses ditolak', 403);
    }

    $this->load->model('Model_mold');
    $affected_rows = $this->Model_mold->sync_data_stock();

    echo "SUKSES! Data stock telah disinkronisasi dengan Qty. \n";
    echo "Total data yang diupdate: " . $affected_rows . " records \n";
}
}
