<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Summery_molding extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        // Model lokal & ERP
        $this->load->model('Model_summery_mold');
        $this->load->model('Model_summery_erp'); // kalau model ERP dipakai di sync()
        $this->load->helper(['url','form']);

        // Guard login
        if (!$this->session->userdata('nama')) {
            redirect('login');
        }
    }

    public function index()
    {
        $data = [
            'title'   => 'Summary Mold',
            'summery' => $this->Model_summery_mold->get_all()
        ];

        // Template sequence (wajib pakai urutan baru)
        $this->load->view('templates/header', $data);
        $this->load->view('templates/sidebar', $data);
        $this->load->view('templates/content_start', $data);   // buka topbar + container
        $this->load->view('summery_molding/summery_mold', $data); // <- VIEW KONTEN SAJA
        $this->load->view('templates/footer');                 // tutup container + wrapper
    }

    public function sync()
    {
        // Ambil data dari ERP
        $rows = $this->Model_summery_erp->get_all_data(); // -> array of associative rows

        // Normalisasi ke array
        if (!is_array($rows)) $rows = [];

        // Mulai transaksi DB lokal
        $this->db->trans_begin();

        try {
            // Kosongkan tabel lokal
            $this->Model_summery_mold->truncate();

            if (!empty($rows)) {
                // Siapkan batch insert (lebih cepat)
                $batch = [];
                foreach ($rows as $r) {
                    $batch[] = [
                        'part_no'        => isset($r['PartNo'])        ? $r['PartNo']        : null,
                        'material_code'  => isset($r['MaterialCode'])  ? $r['MaterialCode']  : null,
                        'part_name'      => isset($r['PartName'])      ? $r['PartName']      : null,
                        'description'    => isset($r['Description'])   ? $r['Description']   : null,
                        'rack_no'        => isset($r['RackNo'])        ? $r['RackNo']        : null,
                        'unit'           => isset($r['Unit'])          ? $r['Unit']          : null,
                        'beginning_qty'  => isset($r['BeginningQty'])  ? $r['BeginningQty']  : 0,
                        'incoming_qty'   => isset($r['IncomingQty'])   ? $r['IncomingQty']   : 0,
                        'outgoing_qty'   => isset($r['OutgoingQty'])   ? $r['OutgoingQty']   : 0,
                        'ending_qty'     => isset($r['EndingQty'])     ? $r['EndingQty']     : 0,
                        'created_by'     => 'system',
                        'last_update'    => date('Y-m-d H:i:s')
                    ];
                }

                // Insert per-chunk biar aman kalau datanya besar
                $chunkSize = 1000;
                $chunks = array_chunk($batch, $chunkSize);
                foreach ($chunks as $c) {
                    $this->db->insert_batch('summery_mold', $c);
                }
            }

            // Commit / Rollback
            if ($this->db->trans_status() === FALSE) {
                $this->db->trans_rollback();
                $this->session->set_flashdata('scan_error', 'Sinkronisasi gagal. (DB error)');
            } else {
                $this->db->trans_commit();
                $count = is_array($rows) ? count($rows) : 0;
                $this->session->set_flashdata('scan_success', "Berhasil sinkron dari SQL Server ($count baris).");
            }

        } catch (Exception $e) {
            $this->db->trans_rollback();
            $this->session->set_flashdata('scan_error', 'Sinkronisasi gagal: '.$e->getMessage());
        }

        redirect('summery_molding');
    }
}
