<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Model_scan extends CI_Model {

     public function insert_scan()
    {
       $this->db->query("INSERT INTO scan_log (sj_number) VALUES (123)");
    }

    public function show(){
        return $this->db->get('scan_log')->result();
    }

    public function get_total_scanned($sj_number, $product_code)
{
    $this->db->select_sum('scan_qty');
    $this->db->where('sj_number', $sj_number);
    $this->db->where('product_code', $product_code);
    $query = $this->db->get('scan_log');

if ($query && $query->num_rows() > 0) {
    return $query->row()->scan_qty ?? 0;
} else {
    return 0;
}
}

    public function get_sj_by_date_range($start_date, $end_date)
{
    return $this->erp
        ->select('h.SJ_number, h.SJ_date')
        ->from('tSuratJalan_h h')
        ->where('h.SJ_date >=', $start_date)
        ->where('h.SJ_date <=', $end_date)
        ->order_by('h.SJ_date', 'ASC')
        ->get()
        ->result();
}

  public function check_sequence_exists($sj_number, $product_code, $sequence)
{
    // Validasi input
    if (empty($sj_number) || empty($product_code) || empty($sequence)) {
        log_message('error', 'Parameter tidak lengkap');
        return false;
    }

    // Perbaikan: Gunakan backtick atau tanpa kutip untuk nama kolom
    $this->db->where('sj_number', $sj_number); // <- perhatikan sj_number bukan si_number
    $this->db->where('product_code', $product_code);
    $this->db->where('sequence', $sequence);
    
    $query = $this->db->get('scan_log');
    
    // Untuk debugging, tambahkan ini sementara:
    echo "Query: ".$this->db->last_query()."<br>";
    
    if (!$query) {
        $error = $this->db->error();
        echo "Error: ".$error['message']."<br>";
        return false;
    }
    
    return $query->num_rows() > 0;
}

}
