<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<!-- Heading + CTA -->
<div class="d-sm-flex align-items-center justify-content-between mb-4">
  <h1 class="h3 mb-0 text-gray-800">Data Karyawan</h1>
  <a href="<?= site_url('karyawan/tambah'); ?>" class="btn btn-primary btn-sm shadow-sm">
    Tambah
  </a>
</div>

<div class="card shadow mb-4">
  <div class="card-body">
    <div class="table-responsive">
      <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
        <thead class="thead-light">
          <tr>
            <th style="width:60px;">No</th>
            <th>Nama</th>
            <th>NIK</th>
            <th>Dept</th>
            <th>Bagian</th>
            <th style="width:150px;">Action</th>
          </tr>
        </thead>
        <tbody>
          <?php if (!empty($karyawan)): ?>
            <?php $no = 1; foreach ($karyawan as $row): ?>
              <tr>
                <td><?= $no++; ?></td>
                <td><?= htmlentities($row->nama); ?></td>
                <td><?= htmlentities($row->nik); ?></td>
                <td><?= htmlentities($row->dept); ?></td>
                <td><?= htmlentities($row->bagian); ?></td>
                <td>
                  <a href="<?= site_url('karyawan/edit/'.$row->id); ?>" class="btn btn-sm btn-primary">
                    Edit
                  </a>
                  <a href="<?= site_url('karyawan/delete/'.$row->id); ?>"
                     class="btn btn-sm btn-danger"
                     onclick="return confirm('Yakin ingin menghapus data ini?');">
                    Delete
                  </a>
                </td>
              </tr>
            <?php endforeach; ?>
          <?php else: ?>
            <tr>
              <td colspan="6" class="text-center text-muted">Belum ada data.</td>
            </tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
