<div class="container-fluid">
    <h1 class="h3 mb-4 text-gray-800">Edit Data Mold</h1>

    <form action="<?= base_url('mold/update') ?>" method="post" autocomplete="off">
        <!-- ID tersembunyi -->
        <input type="hidden" name="id" value="<?= $mold->id ?>">

        <?php
        $fields = [
            ['label' => 'Tanggal', 'name' => 'date', 'type' => 'date', 'required' => true],
            ['label' => 'Part Number', 'name' => 'part_number', 'type' => 'text', 'required' => true],
            ['label' => 'Part Name', 'name' => 'part_name'],
            ['label' => 'Material Code', 'name' => 'material_code'],
            ['label' => 'Customer', 'name' => 'customer'],
            ['label' => 'Machine Type', 'name' => 'machine_type'],
            ['label' => 'Qty', 'name' => 'qty', 'type' => 'number', 'required' => true, 'min' => 0],
            ['label' => 'Cavity', 'name' => 'cavity', 'type' => 'number', 'min' => 0],
            ['label' => 'Status', 'name' => 'status'],
            ['label' => 'PIC Distribusi', 'name' => 'pic_distribusi'],
            ['label' => 'PIC Penerima', 'name' => 'pic_penerima'],
        ];

        foreach ($fields as $f) {
            $type = $f['type'] ?? 'text';
            $required = $f['required'] ?? false;
            $min = isset($f['min']) ? 'min="' . $f['min'] . '"' : '';
        ?>
            <div class="form-group">
                <label for="<?= $f['name'] ?>"><?= $f['label'] ?></label>
                <input 
                    type="<?= $type ?>" 
                    name="<?= $f['name'] ?>" 
                    id="<?= $f['name'] ?>" 
                    class="form-control"
                    style="width: 400px;" 
                    value="<?= htmlspecialchars($mold->{$f['name']} ?? '') ?>" 
                    <?= $required ? 'required' : '' ?> 
                    <?= $min ?>
                >
            </div>
        <?php } ?>
        <?php if (validation_errors()): ?>
    <div class="alert alert-danger">
        <?= validation_errors() ?>
    </div>
<?php endif; ?>


        <button type="submit" class="btn btn-primary">Update</button>
        <a href="<?= base_url('mold') ?>" class="btn btn-secondary">Batal</a>
    </form>
</div>
