<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<?php if (!function_exists('esc')) { function esc($s){ return htmlspecialchars((string)($s ?? ''), ENT_QUOTES, 'UTF-8'); } } ?>

<?php
  // Guard supaya view tetap aman walau controller belum supply data
  $signatures        = isset($signatures) ? (array)$signatures : [];
  $signature_rights  = isset($signature_rights) ? (array)$signature_rights : ['PIC'=>false,'CHECK'=>false,'CONFIRM'=>false,'APPROVE'=>false];
  $can_sign          = isset($can_sign) ? (bool)$can_sign : true;
  $SLOTS             = ['PIC'=>'Pic Piket','CHECK'=>'Check','CONFIRM'=>'Confirmed','APPROVE'=>'Approval'];
?>
<style>
  .btn-gap .btn{margin-right:.5rem}
  .piket-card{background:#fff;border:1px solid #e7eef5;border-radius:10px;box-shadow:0 2px 10px rgba(0,0,0,.03)}
  .grid table{width:100%;border-collapse:collapse}
  .grid th,.grid td{border:1px solid #dde5ee;padding:12px;vertical-align:top}
  .grid th{background:#f8fafc;font-weight:600;color:#405b74}
  .desc{width:28%}.issue{width:42%}.remarks{width:30%}
  .cell-edit{outline:none;min-height:54px;display:block;white-space:pre-wrap}
  .cell-edit:focus{background:#fffdf4;box-shadow:inset 0 0 0 2px #ffe19a}
  .chip-row{display:flex;gap:.75rem;flex-wrap:wrap}
  .chip{position:relative;display:flex;align-items:center;gap:.6rem;padding:.6rem .85rem;border:1px dashed #b8e3c1;border-radius:14px;background:#f2fff5;min-width:160px}
  .chip .icon{width:28px;height:28px;border-radius:50%;background:#22c55e;color:#fff;display:flex;align-items:center;justify-content:center;font-weight:700}
  .chip strong{display:block;line-height:1;color:#124b2e}
  .chip small{display:block;line-height:1.1;color:#3c6e4f}
  .chip input[type=file]{position:absolute;inset:0;opacity:0;cursor:pointer}
  .slot-note{font-size:12px;color:#6b7280;margin-top:.35rem}
  .row-actions{text-align:right}

  /* Signature board */
  .sig-grid{display:grid;grid-template-columns:repeat(4,1fr);gap:.75rem}
  @media (max-width: 992px){ .sig-grid{grid-template-columns:repeat(2,1fr)} }
  @media (max-width: 576px){ .sig-grid{grid-template-columns:1fr} }
  .sig-card{border:1px solid #e5e7eb;border-radius:10px;padding:.75rem}
  .sig-title{font-weight:700;font-size:13px;color:#374151;margin-bottom:.35rem}
  .sig-status{font-size:12px;color:#6b7280}
  .sig-signed{border-color:#a7f3d0;background:#ecfdf5}
  .sig-signed .sig-title{color:#065f46}
  .sig-who{font-weight:600;color:#111827}
  .sig-when{font-size:12px;color:#6b7280}
</style>

<div class="d-flex align-items-center justify-content-between mb-3">
  <h1 class="h3 mb-0 text-gray-800">Edit Laporan Piket</h1>
  <div class="d-flex gap-2">
    <a href="<?= site_url('piket-daily'); ?>" class="btn btn-light border me-2">Kembali</a>
    <a href="<?= site_url('piket-daily/print/'.$header->id); ?>" class="btn btn-secondary">Print A4</a>
  </div>
</div>

<!-- HEADER -->
<div class="piket-card p-3 mb-3">
  <form class="btn-gap" method="post" action="<?= site_url('piket-daily/update-header/'.$header->id); ?>">
    <div class="row g-3 align-items-end">
      <div class="col-md-4">
        <label class="form-label">Nama</label>
        <input name="nama_pengisi" class="form-control" value="<?= esc($header->nama_pengisi); ?>" required>
      </div>
      <div class="col-md-4">
        <label class="form-label">Hari / Tanggal</label>
        <input type="date" name="tanggal" class="form-control" value="<?= esc($header->tanggal); ?>" required>
      </div>
      <div class="col-md-4">
        <label class="form-label">Jam</label>
        <input name="jam_header" class="form-control" value="<?= esc($header->jam_header); ?>" required>
      </div>

      <!-- legacy hidden -->
      <input type="hidden" name="shift" value="<?= esc($header->shift ?: 'PAGI'); ?>">
      <input type="hidden" name="lokasi" value="<?= esc($header->lokasi ?: 'N/A'); ?>">
      <input type="hidden" name="deskripsi" value="<?= esc($header->deskripsi ?: ''); ?>">

      <div class="col-12 mt-2">
        <button class="btn btn-primary me-2">Simpan Header</button>
        <button id="saveAll" type="button" class="btn btn-outline-primary">Simpan semua baris</button>
      </div>
    </div>
  </form>
</div>

<!-- SIGNATURE BOARD -->
<div class="piket-card p-3 mb-3">
  <div class="d-flex align-items-center justify-content-between mb-2">
    <strong>Signature</strong>
    <?php if (!$can_sign): ?>
      <small class="text-muted">Dokumen ini sedang dikunci atau Anda tidak dapat mengubah tanda tangan.</small>
    <?php endif; ?>
  </div>

  <div class="sig-grid" id="sigGrid">
    <?php foreach ($SLOTS as $slotKey => $slotLabel):
      $row = isset($signatures[$slotKey]) ? $signatures[$slotKey] : null;
      $isSigned = $row && !empty($row->signed_by);
      $canThis  = !empty($signature_rights[$slotKey]) && $can_sign;
    ?>
    <div class="sig-card <?= $isSigned ? 'sig-signed':''; ?>" data-slot="<?= esc($slotKey) ?>">
      <div class="sig-title"><?= esc($slotLabel) ?></div>

      <div class="sig-status">
        <?php if ($isSigned): ?>
          <div class="sig-who"><?= esc($row->signed_by_name ?? ''); ?></div>
          <div class="sig-when"><?= esc($row->signed_at ?? ''); ?></div>
        <?php else: ?>
          <em>Belum ditandatangani</em>
        <?php endif; ?>
      </div>

      <?php if ($canThis): ?>
        <div class="mt-2 d-flex gap-2">
          <?php if (!$isSigned): ?>
            <button type="button" class="btn btn-sm btn-success act-sign">Sign</button>
          <?php else: ?>
            <button type="button" class="btn btn-sm btn-outline-danger act-unsign">Unsign</button>
          <?php endif; ?>
        </div>
      <?php endif; ?>
    </div>
    <?php endforeach; ?>
  </div>
</div>

<!-- GRID -->
<div class="piket-card p-3 grid">
  <table>
    <thead>
      <tr>
        <th class="desc">DESCRIPTION</th>
        <th class="issue">ISSUE</th>
        <th class="remarks">REMARKS (PHOTOS)</th>
      </tr>
    </thead>
    <tbody>
    <?php foreach ($lines as $idx => $line):
      $left = [];
      if (!empty($line->section))   $left[] = '<strong>'.esc($line->section).'</strong>';
      if (!empty($line->time_slot)) $left[] = '<div class="text-muted" style="font-size:12px">'.esc($line->time_slot).'</div>';
      $leftHtml = $left ? implode('<br>', $left) : '&nbsp;';

      $li = (string)$idx;
      $list = $photos_by_line[$li] ?? [];
      $byUrutan = [0=>null,1=>null,2=>null];
      foreach ($list as $p){ $byUrutan[(int)$p->urutan] = $p; }
    ?>
      <tr data-line-id="<?= (int)$line->id; ?>" data-line-index="<?= (int)$idx; ?>">
        <td class="desc"><?= $leftHtml; ?></td>

        <td>
          <div class="cell-edit cell-issue" contenteditable="true"><?= nl2br(esc($line->issue)); ?></div>
          <div class="row-actions mt-2">
            <button type="button" class="btn btn-sm btn-outline-primary save-row">Simpan baris</button>
          </div>
        </td>

        <td>
          <div class="chip-row">
            <?php for ($s=1;$s<=3;$s++): ?>
              <label class="chip" data-slot="<?= $s; ?>" title="Klik untuk pilih foto">
                <span class="icon">📷</span>
                <div>
                  <strong>Foto <?= $s; ?></strong>
                  <small>≤1MB, landscape</small>
                </div>
                <input type="file" accept=".jpg,.jpeg,.png" class="slot-file">
              </label>
            <?php endfor; ?>
          </div>
          <div class="slot-note">Maks 3 foto per baris. Server otomatis kompres ≤ 1MB & paksa landscape.</div>
        </td>
      </tr>
    <?php endforeach; ?>
    </tbody>
  </table>
</div>

<script>
(() => {
  // Endpoints — pakai nama controller (non-dashed) biar aman
  const URL_SAVE      = '<?= site_url('PiketDaily/save_row'); ?>';
  const URL_UP_PHOTO  = '<?= site_url('PiketDaily/upload_one_photo'); ?>';
  const URL_SIGN      = '<?= site_url('PiketDaily/sign'); ?>';
  const URL_UNSIGN    = '<?= site_url('PiketDaily/unsign'); ?>';
  const PIKET_ID      = <?= (int)$header->id; ?>;

  /* ---------- Helpers ---------- */

  function getPlain(el){
    const html = (el.innerHTML || '').replace(/<br\s*\/?>/gi, '\n');
    const tmp  = document.createElement('div'); tmp.innerHTML = html;
    return (tmp.textContent || '').replace(/\u00A0/g,' ').trim();
  }
  function stripTags(s){ const d=document.createElement('div'); d.innerHTML = s; return d.textContent || d.innerText || ''; }
  async function fetchJSON(url, options){
    const res  = await fetch(url, options || {});
    const text = await res.text();
    try { return JSON.parse(text); } catch { throw new Error(stripTags(text).slice(0, 400) || 'Respons bukan JSON'); }
  }
  function postUrlEncoded(url, obj){
    return fetchJSON(url, {
      method: 'POST',
      headers: { 'Content-Type':'application/x-www-form-urlencoded; charset=UTF-8','X-Requested-With':'XMLHttpRequest' },
      body: new URLSearchParams(obj)
    });
  }
  function setBusy(btn, yes){
    if (!btn) return;
    btn.disabled = !!yes;
    if (yes) { btn.dataset._label = btn.textContent; btn.textContent = 'Menyimpan…'; }
    else     { btn.textContent = btn.dataset._label || btn.textContent; }
  }

  /* ---------- Simpan baris (ISSUE) ---------- */

  async function saveOneRow(tr, btn){
    const id    = tr.dataset.lineId;
    const issue = getPlain(tr.querySelector('.cell-issue'));
    if (!id) throw new Error('ID baris tidak ditemukan');
    setBusy(btn, true);
    try{
      const j = await postUrlEncoded(URL_SAVE, { id, issue });
      if (!j || j.ok !== true) throw new Error(j?.msg || 'Gagal menyimpan');
      btn.classList.remove('btn-outline-primary'); btn.classList.add('btn-success');
      btn.textContent = 'Tersimpan ✓';
      setTimeout(() => { btn.classList.remove('btn-success'); btn.classList.add('btn-outline-primary'); btn.textContent = 'Simpan baris'; }, 900);
    } finally { setBusy(btn, false); }
  }
  document.querySelectorAll('.save-row').forEach(btn => {
    btn.addEventListener('click', () => {
      const tr = btn.closest('tr');
      saveOneRow(tr, btn).catch(err => alert(err.message || 'Gagal menyimpan baris.'));
    });
  });
  document.getElementById('saveAll')?.addEventListener('click', async (ev) => {
    const rows = Array.from(document.querySelectorAll('tbody tr'));
    const orig = ev.target.textContent;
    ev.target.disabled = true; ev.target.textContent = 'Menyimpan semua…';
    try{
      for (const tr of rows) {
        await postUrlEncoded(URL_SAVE, { id: tr.dataset.lineId, issue: getPlain(tr.querySelector('.cell-issue')) });
      }
      alert('Semua baris disimpan.');
    } catch (e){ alert(e.message || 'Sebagian baris gagal disimpan.'); }
    finally { ev.target.disabled = false; ev.target.textContent = orig; }
  });

  /* ---------- Upload foto per-slot ---------- */

  function validateImage(file){
    const okType = ['image/jpeg','image/png'].includes(file.type);
    if (!okType) return 'Hanya JPG/PNG.';
    if (file.size > 15 * 1024 * 1024) return 'Ukuran file terlalu besar (>15MB).';
    return null;
  }
  async function uploadSlot(chip, file, lineIndex, slot){
    const err = validateImage(file);
    if (err) throw new Error(err);
    const prevBorder = chip.style.border;
    chip.style.opacity = '.6'; chip.style.border  = '1px dashed #86efac';
    const fd = new FormData();
    fd.append('piket_id',   PIKET_ID);
    fd.append('line_index', lineIndex);
    fd.append('slot',       slot);
    fd.append('photo',      file);
    try{
      const j = await fetchJSON(URL_UP_PHOTO, { method:'POST', headers:{ 'X-Requested-With':'XMLHttpRequest' }, body: fd });
      if (!j || j.ok !== true) throw new Error(j?.msg || 'Upload gagal');
      chip.style.border = '1px solid #22c55e';
      chip.querySelector('div strong').textContent = 'Foto ' + slot + ' ✓';
    } finally {
      chip.style.opacity = '1';
      if (!chip.style.border.includes('#22c55e')) chip.style.border = prevBorder;
    }
  }
  document.querySelectorAll('.slot-file').forEach(input => {
    input.addEventListener('change', async (ev) => {
      const file = ev.target.files?.[0]; ev.target.value = '';
      if (!file) return;
      const tr   = ev.target.closest('tr');
      const chip = ev.target.closest('.chip');
      const lineIndex = tr?.dataset.lineIndex;
      const slot = chip?.dataset.slot;
      if (!tr || !chip || !lineIndex || !slot) { alert('Context upload tidak lengkap.'); return; }
      try{ await uploadSlot(chip, file, lineIndex, slot); }catch(e){ alert(e.message || 'Upload gagal.'); }
    });
  });

  /* ---------- Signature actions ---------- */

  function renderSigCard(card, payload){
    // payload: {slot, signed_by_name, signed_at} jika sign; null jika unsign
    const status = card.querySelector('.sig-status');
    const btnBox = card.querySelector('.mt-2.d-flex');
    if (payload){
      card.classList.add('sig-signed');
      status.innerHTML = `<div class="sig-who">${payload.signed_by_name||''}</div><div class="sig-when">${payload.signed_at||''}</div>`;
      if (btnBox){
        btnBox.innerHTML = `<button type="button" class="btn btn-sm btn-outline-danger act-unsign">Unsign</button>`;
      }
    }else{
      card.classList.remove('sig-signed');
      status.innerHTML = `<em>Belum ditandatangani</em>`;
      if (btnBox){
        btnBox.innerHTML = `<button type="button" class="btn btn-sm btn-success act-sign">Sign</button>`;
      }
    }
  }

  async function doSign(slot, card){
    const j = await postUrlEncoded(URL_SIGN, { piket_id: PIKET_ID, slot_role: slot });
    if (!j || j.ok !== true) throw new Error(j?.msg || 'Gagal sign');
    renderSigCard(card, j);
  }
  async function doUnsign(slot, card){
    const j = await postUrlEncoded(URL_UNSIGN, { piket_id: PIKET_ID, slot_role: slot });
    if (!j || j.ok !== true) throw new Error(j?.msg || 'Gagal unsign');
    renderSigCard(card, null);
  }

  document.getElementById('sigGrid')?.addEventListener('click', (e)=>{
    const card = e.target.closest('.sig-card'); if (!card) return;
    const slot = card.dataset.slot;
    if (e.target.classList.contains('act-sign')){
      doSign(slot, card).catch(err => alert(err.message || 'Gagal sign.'));
    } else if (e.target.classList.contains('act-unsign')){
      if (confirm('Batalkan tanda tangan untuk slot ini?')){
        doUnsign(slot, card).catch(err => alert(err.message || 'Gagal unsign.'));
      }
    }
  });

})();
</script>
