<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<?php
// helper escape
if (!function_exists('esc')) {
    function esc($s){ return htmlspecialchars((string)($s ?? ''), ENT_QUOTES, 'UTF-8'); }
}

$me_id   = (int)($this->session->userdata('user_id') ?: 0);
$me_role = strtolower((string)($this->session->userdata('role') ?: ''));
?>

<style>
  .tbl-piket td.col-nomor,
  .tbl-piket td.col-tanggal,
  .tbl-piket td.col-pic,
  .tbl-piket td.col-dibuat,
  .tbl-piket th.col-nomor,
  .tbl-piket th.col-tanggal,
  .tbl-piket th.col-pic,
  .tbl-piket th.col-dibuat { font-size:12px; }

  .status-badge{
    display:inline-block; padding:2px 8px; border-radius:6px;
    font-size:11px; font-weight:700; color:#fff; margin-right:6px;
  }
  .status-badge.empty  { background:#9aa3af; }
  .status-badge.pic    { background:#0891b2; }
  .status-badge.check  { background:#10b981; }
  .status-badge.conf   { background:#6366f1; }
  .status-badge.appr   { background:#f59e0b; }

  .btn-stack .btn{ margin-right:6px; margin-bottom:6px; }

  .btn.disabled, .btn[aria-disabled="true"]{
    pointer-events:none; opacity:.55;
  }
</style>

<div class="container-fluid">
  <div class="d-flex justify-content-between align-items-center mb-2">
    <h1 class="h3 text-gray-800">Piket Daily</h1>
    <a class="btn btn-success" href="<?= site_url('piket-daily/create'); ?>">+ Entry Baru</a>
  </div>

  <?php if ($msg = $this->session->flashdata('scan_success')): ?>
    <div class="alert alert-success"><?= esc($msg) ?></div>
  <?php endif; ?>
  <?php if ($msg = $this->session->flashdata('scan_error')): ?>
    <div class="alert alert-danger"><?= esc($msg) ?></div>
  <?php endif; ?>

  <div class="card shadow">
    <div class="card-body table-responsive">
      <table class="table table-hover align-middle mb-0 tbl-piket">
        <thead>
          <tr>
            <th class="col-nomor"   style="width:160px;">No. Laporan</th>
            <th class="col-tanggal" style="width:110px;">Tanggal</th>
            <th class="col-pic"     style="width:220px;">PIC / Nama Pengisi</th>
            <th class="col-dibuat"  style="width:170px;">Dibuat</th>
            <th style="width:220px;">Status Sign</th>
            <th style="width:320px;">Aksi</th>
          </tr>
        </thead>
        <tbody>
        <?php if (!empty($rows)): ?>
          <?php foreach ($rows as $r): ?>
            <?php
              $is_owner = ((int)$r->dibuat_oleh === $me_id);
              $is_admin = in_array($me_role, ['admin','superadmin'], true);
              $can_edit = $is_owner || $is_admin;

              $no_lap = sprintf('PD-%s-%04d',
                str_replace('-', '', substr($r->tanggal, 0, 10)),
                (int)$r->id
              );

              // status sign dari controller
              $s = $sign_matrix[$r->id] ?? [
                  'PIC'     => false,
                  'CHECK'   => false,
                  'CONFIRM' => false,
                  'APPROVE' => false,
              ];

              $sessionName = (string)(
                  $this->session->userdata('nama')
                  ?: $this->session->userdata('username')
                  ?: ''
              );
              $nameMatch = $sessionName &&
                           strcasecmp($sessionName, (string)$r->nama_pengisi) === 0;

              // aturan hak sign:
              // - PIC     : admin/user + (owner atau nama_pengisi sama)
              // - CHECK   : role "check" atau admin
              // - CONFIRM : role "confirmed" atau admin
              // - APPROVE : role "approval" atau admin
              $can_pic     = !$s['PIC']     && ( $is_owner || $nameMatch || in_array($me_role, ['admin','user'], true) );
              $can_check   =  $s['PIC']     && !$s['CHECK']   && in_array($me_role, ['check','admin'], true);
              $can_confirm =  $s['CHECK']   && !$s['CONFIRM'] && in_array($me_role, ['confirmed','admin'], true);
              $can_approve =  $s['CONFIRM'] && !$s['APPROVE'] && in_array($me_role, ['approval','admin'], true);
            ?>
            <tr>
              <td class="col-nomor"><?= esc($no_lap) ?></td>
              <td class="col-tanggal"><?= esc($r->tanggal) ?></td>
              <td class="col-pic"><?= esc($r->nama_pengisi ?: '—') ?></td>
              <td class="col-dibuat"><?= esc($r->dibuat_pada) ?></td>

              <td>
                <span class="status-badge <?= $s['PIC']?'pic':'empty' ?>">PIC</span>
                <span class="status-badge <?= $s['CHECK']?'check':'empty' ?>">CHECK</span>
                <span class="status-badge <?= $s['CONFIRM']?'conf':'empty' ?>">CONFIRM</span>
                <span class="status-badge <?= $s['APPROVE']?'appr':'empty' ?>">APPROVE</span>
              </td>

              <td class="btn-stack">
                <a class="btn btn-sm btn-outline-success <?= $can_pic?'':'disabled' ?>"
                   aria-disabled="<?= $can_pic?'false':'true' ?>"
                   href="<?= $can_pic ? site_url('PiketDaily/sign_pad/'.(int)$r->id.'/PIC') : '#' ?>">
                  Sign PIC
                </a>

                <a class="btn btn-sm btn-outline-success <?= $can_check?'':'disabled' ?>"
                   aria-disabled="<?= $can_check?'false':'true' ?>"
                   href="<?= $can_check ? site_url('PiketDaily/sign_pad/'.(int)$r->id.'/CHECK') : '#' ?>">
                  Sign Check
                </a>

                <a class="btn btn-sm btn-outline-primary <?= $can_confirm?'':'disabled' ?>"
                   aria-disabled="<?= $can_confirm?'false':'true' ?>"
                   href="<?= $can_confirm ? site_url('PiketDaily/sign_pad/'.(int)$r->id.'/CONFIRM') : '#' ?>">
                  Sign Confirm
                </a>

                <a class="btn btn-sm btn-outline-warning <?= $can_approve?'':'disabled' ?>"
                   aria-disabled="<?= $can_approve?'false':'true' ?>"
                   href="<?= $can_approve ? site_url('PiketDaily/sign_pad/'.(int)$r->id.'/APPROVE') : '#' ?>">
                  Sign Approve
                </a>

                <?php if ($can_edit): ?>
                  <a class="btn btn-sm btn-outline-secondary"
                     href="<?= site_url('piket-daily/edit/'.(int)$r->id) ?>">
                    Edit
                  </a>

                  <a class="btn btn-sm btn-outline-secondary" target="_blank"
                     href="<?= site_url('piket-daily/print/'.(int)$r->id) ?>">
                    Print
                  </a>

                  <form action="<?= site_url('piket-daily/destroy/'.(int)$r->id) ?>"
                        method="post" class="d-inline"
                        onsubmit="return confirm('Hapus laporan ini beserta semua foto & tanda tangan?');">
                    <button type="submit" class="btn btn-sm btn-outline-danger">Delete</button>
                  </form>
                <?php else: ?>
                  <span class="badge bg-secondary">—</span>
                <?php endif; ?>
              </td>
            </tr>
          <?php endforeach; ?>
        <?php else: ?>
          <tr>
            <td colspan="6" class="text-center text-muted py-4">
              Belum ada data.
            </td>
          </tr>
        <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
