<?php defined('BASEPATH') OR exit('No direct script access allowed');

if (!function_exists('esc')) {
    function esc($s){
        return htmlspecialchars((string)($s ?? ''), ENT_QUOTES, 'UTF-8');
    }
}

/* =======================================================
 *   HEADER INFO
 * ======================================================= */
$hariMap   = ['Minggu','Senin','Selasa','Rabu','Kamis','Jumat','Sabtu'];
$tanggal   = $header->tanggal ?? date('Y-m-d');
$ts        = strtotime($tanggal);
$hari      = $hariMap[(int)date('w', $ts)];
$tgl_view  = date('d-m-Y', $ts);

$rawJam    = (string)($header->jam_header ?? '');
$jam_view  = str_replace('.', ':', $rawJam);
$pic_name  = (string)($header->nama_pengisi ?? '-');

/* =======================================================
 *   SIGNATURES – DARI CONTROLLER + FALLBACK LAMA
 * ======================================================= */
$S = [
    'PIC'     => $Sign['PIC']     ?? null,
    'CHECK'   => $Sign['CHECK']   ?? null,
    'CONFIRM' => $Sign['CONFIRM'] ?? null,
    'APPROVE' => $Sign['APPROVE'] ?? null,
];

/* Notes dari controller (kalau ada) */
$Notes = (isset($Notes) && is_array($Notes)) ? $Notes : [];

/* =======================================================
 *   FALLBACK SCAN FILE
 * ======================================================= */
$slots = ['PIC','CHECK','CONFIRM','APPROVE'];

foreach ($slots as $slot) {
    if ($S[$slot] && !empty($S[$slot]->image_path)) {
        continue;
    }

    $patternPng = FCPATH . 'uploads/piket_signatures/SIG_' . $header->id . '_' . $slot . '_*.png';
    $patternJpg = FCPATH . 'uploads/piket_signatures/SIG_' . $header->id . '_' . $slot . '_*.jpg';

    $files = array_merge(glob($patternPng) ?: [], glob($patternJpg) ?: []);
    if (!$files) continue;

    $first = $files[0];
    $rel   = 'uploads/piket_signatures/' . basename($first);

    $obj = $S[$slot] ?: new stdClass();
    $obj->image_path  = $obj->image_path ?? $rel;

    if (empty($obj->signer_name) && $slot === 'PIC') {
        $obj->signer_name = $pic_name;
    }

    if (empty($obj->signed_at)) {
        $mtime = @filemtime($first);
        $obj->signed_at = $mtime ? date('Y-m-d H:i:s', $mtime) : ($header->tanggal . ' ' . $jam_view);
    }

    $S[$slot] = $obj;
}

/* =======================================================
 *   HELPERS
 * ======================================================= */
$showName = function($obj){
    if (!$obj) return '';
    foreach (['signer_name','signed_by_name','display_name','username','user_name'] as $k) {
        if (isset($obj->$k) && trim((string)$obj->$k) !== '') {
            return (string)$obj->$k;
        }
    }
    return '';
};

$showSignedAt = function($obj){
    if (!$obj || empty($obj->signed_at)) return '';
    $ts = strtotime($obj->signed_at);
    if ($ts) return date('d-m-Y H:i', $ts);
    return (string)$obj->signed_at;
};

$imgSrc = function($obj){
    if (!$obj) return null;
    if (!empty($obj->img_src)) {
        return $obj->img_src;
    }
    if (!empty($obj->image_path)) {
        return base_url(ltrim($obj->image_path,'/'));
    }
    return null;
};

/* =======================================================
 *   AUTO BUILD NOTES (KALAU BELUM DIKIRIM CONTROLLER)
 * ======================================================= */
if (empty($Notes)) {
    $autoNotes = [];
    $noteRoles = [
        'CHECK'   => 'Checker',
        'CONFIRM' => 'Confirmed',
        'APPROVE' => 'Approval',
    ];

    foreach ($noteRoles as $key => $label) {
        $obj = $S[$key] ?? null;
        if ($obj && isset($obj->note) && trim((string)$obj->note) !== '') {
            $autoNotes[] = [
                'role' => $label,
                'name' => $showName($obj),
                'time' => $showSignedAt($obj),
                'text' => (string)$obj->note,
            ];
        }
    }

    $Notes = $autoNotes;
}
?>
<!DOCTYPE html>
<html>
<head>
<meta charset="utf-8">
<title>Daily Laporan Piket</title>
<style>
  @page {
    size: A4 portrait;
    margin: 8mm 6mm 8mm 6mm;
  }
  body {
    font-family: Arial, Helvetica, sans-serif;
    font-size: 9px;
    color:#000;
  }
  table { border-collapse: collapse; width:100%; }

  .title {
    font-weight:1000;
    font-size:25px;
    margin:0 0 4px;
  }

  .sig-wrap { width:100%; border-collapse:collapse; table-layout:fixed; }
  .sig-wrap th, .sig-wrap td { border:1px solid #000; text-align:center; }
  .sig-hd {
      font-weight:bold;
      font-size:8.5px;
      padding:1px 0;
      background:#eee;
  }
  .sig-box { height:52px; vertical-align:middle; padding:1px; }
  .sig-img {
      width:70px;
      height:40px;
      object-fit:contain;
      display:block;
      margin:0 auto;
  }
  .sig-meta {
      font-size:8px;
      margin-top:1px;
      line-height:1.1;
      min-height:18px;
  }

  .label { width:100px; display:inline-block; }
  .hrline-small {
      border-bottom:1px solid #000;
      display:inline-block;
      padding:0 2px;
      min-width:120px;
      white-space:nowrap;
  }
  .inline-small { display:inline-block; margin-right:4px; }

  .tbl {
      border:1px solid #000;
      min-height: 200mm;
  }
  .tbl th, .tbl td {
      border:1px solid #000;
      padding:7px;
      vertical-align:top;
  }
  .center { text-align:center; }
  .desc-cell { width:26%; }
  .issue-cell { width:38%; }
  .rem-cell  { width:36%; }

  .section { font-weight:700; }
  .slot { font-size:8px; color:#555; }

  .pgrid {
      width:100%;
      border-collapse:separate;
      border-spacing:2px 2px;
      table-layout:fixed;
  }
  .pgrid td {
    width:33.333%;
    height:42px;
    border:1px solid #666;
    padding:1px;
    vertical-align:middle;
    text-align:center;
  }
  .thumb {
    width:100%;
    height:38px;
    object-fit:cover;
    display:block;
  }

  .note-title {
      font-weight:bold;
      margin:6px 0 3px;
      font-size:9px;
  }
  .note-table {
      border-collapse:collapse;
      width:100%;
      margin-top:2px;
      margin-bottom:4px;
  }
  .note-table th,
  .note-table td {
      border:1px solid #000;
      padding:3px;
      vertical-align:top;
  }
  .note-table th {
      background:#f1f1f1;
      text-align:left;
      font-weight:bold;
  }
</style>
</head>
<body>

<!-- TITLE + SIGNATURE -->
<table style="width:100%; margin-bottom:4px;">
  <tr>
    <td class="title">DAILY LAPORAN PIKET</td>
    <td style="width:420px;">
      <table class="sig-wrap">
        <colgroup>
          <col style="width:25%">
          <col style="width:25%">
          <col style="width:25%">
          <col style="width:25%">
        </colgroup>
        <tr>
          <th class="sig-hd">Pic Piket</th>
          <th class="sig-hd">Check</th>
          <th class="sig-hd">Confirmed</th>
          <th class="sig-hd">Approval</th>
        </tr>
        <tr>
          <td class="sig-box">
            <?php if ($src = $imgSrc($S['PIC'])): ?>
              <img class="sig-img" src="<?= $src ?>">
            <?php endif; ?>
            <div class="sig-meta">
              <?= esc($showName($S['PIC'])) ?>
              <?php if ($dt = $showSignedAt($S['PIC'])): ?><br><?= esc($dt) ?><?php endif; ?>
            </div>
          </td>
          <td class="sig-box">
            <?php if ($src = $imgSrc($S['CHECK'])): ?>
              <img class="sig-img" src="<?= $src ?>">
            <?php endif; ?>
            <div class="sig-meta">
              <?= esc($showName($S['CHECK'])) ?>
              <?php if ($dt = $showSignedAt($S['CHECK'])): ?><br><?= esc($dt) ?><?php endif; ?>
            </div>
          </td>
          <td class="sig-box">
            <?php if ($src = $imgSrc($S['CONFIRM'])): ?>
              <img class="sig-img" src="<?= $src ?>">
            <?php endif; ?>
            <div class="sig-meta">
              <?= esc($showName($S['CONFIRM'])) ?>
              <?php if ($dt = $showSignedAt($S['CONFIRM'])): ?><br><?= esc($dt) ?><?php endif; ?>
            </div>
          </td>
          <td class="sig-box">
            <?php if ($src = $imgSrc($S['APPROVE'])): ?>
              <img class="sig-img" src="<?= $src ?>">
            <?php endif; ?>
            <div class="sig-meta">
              <?= esc($showName($S['APPROVE'])) ?>
              <?php if ($dt = $showSignedAt($S['APPROVE'])): ?><br><?= esc($dt) ?><?php endif; ?>
            </div>
          </td>
        </tr>
      </table>
    </td>
  </tr>
</table>

<!-- IDENTITAS -->
<table style="margin-bottom:2px;">
  <tr>
    <td style="width:50%">
      <span class="label">NAMA</span> :
      <span class="hrline-small"><?= esc($pic_name) ?></span>
    </td>
    <td style="width:50%">
      <div class="inline-small">
        <span class="label">HARI / TANGGAL</span> :
        <span class="hrline-small"><?= esc($hari . ', ' . $tgl_view) ?></span>
      </div>
      <div class="inline-small">
        <span class="label">JAM</span> :
        <span class="hrline-small"><?= esc($jam_view) ?></span>
      </div>
    </td>
  </tr>
</table>

<!-- ==== CATATAN / NOTE – DIPINDAH KE ATAS TABEL ISI ==== -->
<?php if (!empty($Notes)): ?>
  <div class="note-title">CATATAN / NOTE</div>
  <table class="note-table">
    <thead>
      <tr>
        <th style="width:18%;">Role</th>
        <th style="width:22%;">Nama</th>
        <th style="width:20%;">Waktu Sign</th>
        <th style="width:40%;">Catatan</th>
      </tr>
    </thead>
    <tbody>
      <?php foreach ($Notes as $n): ?>
        <tr>
          <td><?= esc($n['role']) ?></td>
          <td><?= esc($n['name']) ?></td>
          <td><?= esc($n['time']) ?></td>
          <td><?= nl2br(esc($n['text'])) ?></td>
        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
<?php endif; ?>

<!-- GRID: DESCRIPTION | ISSUE | REMARKS -->
<table class="tbl">
  <thead>
    <tr class="center">
      <th class="desc-cell">DESCRIPTION</th>
      <th class="issue-cell">ISSUE</th>
      <th class="rem-cell">REMARKS (Photos)</th>
    </tr>
  </thead>
  <tbody>
  <?php foreach ($lines as $i => $ln): ?>
    <tr>
      <td>
        <?php if (!empty($ln->section)): ?>
          <div class="section"><?= esc($ln->section) ?></div>
        <?php endif; ?>
        <?php if (!empty($ln->time_slot)): ?>
          <div class="slot"><?= esc($ln->time_slot) ?></div>
        <?php endif; ?>
      </td>
      <td><?= nl2br(esc($ln->issue ?? '')) ?></td>
      <td>
        <?php
          $arr = $photos_by_line[(string)$i] ?? [];
          if (!empty($arr)):
            $chunks = array_chunk($arr, 3);
        ?>
          <table class="pgrid">
            <?php foreach ($chunks as $chunk): ?>
              <tr>
                <?php for ($c=0; $c<3; $c++): $p = $chunk[$c] ?? null; ?>
                  <td>
                    <?php if ($p): ?>
                      <img class="thumb"
                           src="<?= base_url(ltrim($p->file_path,'/')) ?>"
                           alt="<?= esc(basename($p->file_path)) ?>">
                    <?php endif; ?>
                  </td>
                <?php endfor; ?>
              </tr>
            <?php endforeach; ?>
          </table>
        <?php endif; ?>
      </td>
    </tr>
  <?php endforeach; ?>
  </tbody>
</table>

</body>
</html>
