<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<?php
// helper kecil untuk escape HTML
if (!function_exists('esc')) {
    function esc($s){ return htmlspecialchars((string)($s ?? ''), ENT_QUOTES, 'UTF-8'); }
}

$slot      = strtoupper((string)($slot_role ?? 'PIC'));
$header    = $header ?? null;
$exists    = $exists ?? null;

$titleMap  = [
    'PIC'     => 'Pic Piket',
    'CHECK'   => 'Check',
    'CONFIRM' => 'Confirmed',
    'APPROVE' => 'Approval',
];
$slotLabel = $titleMap[$slot] ?? $slot;

$noLaporan = $header ? sprintf('PD-%s-%04d',
    str_replace('-', '', substr($header->tanggal, 0, 10)),
    (int)$header->id
) : '-';

$picName   = $header->nama_pengisi ?? '';
$tanggal   = $header->tanggal ?? '';
$jamHeader = $header->jam_header ?? '';
?>

<div class="container-fluid">

    <div class="d-flex justify-content-between align-items-center mb-3">
        <h1 class="h4 text-gray-800 mb-0">
            Tanda Tangan <?= esc($slotLabel) ?> –
            <span class="text-muted"><?= esc($noLaporan) ?></span>
        </h1>

        <a href="<?= site_url('piket-daily'); ?>" class="btn btn-sm btn-secondary">
            &laquo; Kembali ke daftar
        </a>
    </div>

    <?php if ($header): ?>
        <div class="card mb-3 shadow-sm">
            <div class="card-body py-2">
                <div class="row small">
                    <div class="col-md-4">
                        <strong>Tanggal</strong><br>
                        <?= esc($tanggal) ?>
                    </div>
                    <div class="col-md-4">
                        <strong>PIC / Nama Pengisi</strong><br>
                        <?= esc($picName ?: '—') ?>
                    </div>
                    <div class="col-md-4">
                        <strong>Jam</strong><br>
                        <?= esc($jamHeader ?: '—') ?>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <div class="row">
        <!-- KOLOM KIRI: 3 OPSI -->
        <div class="col-lg-7">

            <!-- OPSI 1: CANVAS -->
            <div class="card shadow-sm mb-4">
                <div class="card-header py-2">
                    <h6 class="m-0 font-weight-bold text-primary">
                        Opsi 1 – Tanda tangan di canvas
                    </h6>
                </div>

                <div class="card-body">
                    <p class="small text-muted mb-2">
                        Gunakan mouse / touchscreen untuk menggambar tanda tangan di area berikut.
                    </p>

                    <div class="border rounded bg-light d-flex justify-content-center align-items-center"
                         style="height: 190px;">
                        <canvas id="sigCanvas"
                                width="600"
                                height="160"
                                style="background:#fff; border:1px solid #ccc; border-radius:4px; cursor:crosshair;">
                        </canvas>
                    </div>

                    <div class="mt-2">
                        <button type="button" id="btn-clear-canvas"
                                class="btn btn-sm btn-outline-secondary">
                            Bersihkan Canvas
                        </button>

                        <!-- tombol ini yang akan mengirim data canvas -->
                        <button type="button" id="btn-save-canvas"
                                class="btn btn-sm btn-primary">
                            Simpan dari Canvas
                        </button>

                        <span class="small text-muted ml-2">
                            Data akan dikirim sebagai gambar PNG.
                        </span>
                    </div>
                </div>
            </div>

            <!-- OPSI 2: UPLOAD FILE -->
            <div class="card shadow-sm mb-4">
                <div class="card-header py-2">
                    <h6 class="m-0 font-weight-bold text-info">
                        Opsi 2 – Upload file gambar tanda tangan
                    </h6>
                </div>
                <div class="card-body">
                    <p class="small text-muted mb-2">
                        Jika sudah punya file tanda tangan (PNG/JPG), upload di sini lalu klik
                        <strong>Simpan / Kirim</strong>.
                    </p>

                    <div class="form-group mb-2">
                        <label class="small mb-1">File tanda tangan (PNG / JPG)</label>
                        <input type="file"
                               name="sign_file"
                               form="form-sign"
                               accept="image/png,image/jpeg"
                               class="form-control form-control-sm">
                    </div>

                    <button type="submit"
                            form="form-sign"
                            class="btn btn-sm btn-success">
                        Simpan / Kirim
                    </button>

                    <p class="small text-muted mt-2 mb-0">
                        Jika Anda memilih file di atas, file tersebut akan dipakai sebagai tanda tangan
                        untuk laporan ini. Jika tidak ada file dan tidak memakai canvas, sistem akan
                        menampilkan pesan error.
                    </p>
                </div>
            </div>

            <!-- OPSI 3: TTD TERSIMPAN -->
            <div class="card shadow-sm mb-4">
                <div class="card-header py-2">
                    <h6 class="m-0 font-weight-bold text-success">
                        Opsi 3 – Gunakan tanda tangan tersimpan
                    </h6>
                </div>
                <div class="card-body">
                    <p class="small text-muted mb-2">
                        Sistem akan mencari file tanda tangan master berdasarkan username Anda di:
                        <code>uploads/piket_signatures_data/{username}.png/jpg</code>.
                    </p>

                    <button type="button"
                            id="btn-use-stored"
                            class="btn btn-sm btn-outline-success">
                        Gunakan tanda tangan tersimpan
                    </button>
                </div>
            </div>

        </div>

        <!-- KOLOM KANAN: FORM & INFO -->
        <div class="col-lg-5">

            <!-- FORM UTAMA -->
            <form id="form-sign"
                  method="post"
                  action="<?= site_url('PiketDaily/sign_submit'); ?>"
                  enctype="multipart/form-data">

                <input type="hidden" name="piket_id"  value="<?= (int)$header->id ?>">
                <input type="hidden" name="slot_role" value="<?= esc($slot) ?>">
                <input type="hidden" name="image_data" id="image_data">
                <!-- flag untuk opsi 3 -->
                <input type="hidden" name="use_stored" id="use_stored" value="0">

                <div class="card shadow-sm mb-4">
                    <div class="card-header py-2">
                        <h6 class="m-0 font-weight-bold text-secondary">
                            Informasi Tanda Tangan
                        </h6>
                    </div>
                    <div class="card-body">

                        <p class="small mb-2">
                            Slot tanda tangan: <strong><?= esc($slotLabel) ?></strong>
                        </p>

                        <?php if ($exists && !empty($exists->image_path)): ?>
                            <div class="mb-3">
                                <div class="small text-muted mb-1">Tanda tangan yang sudah ada:</div>
                                <div class="border rounded p-2 text-center bg-light">
                                    <img src="<?= base_url(ltrim($exists->image_path,'/')); ?>"
                                         alt="Existing signature"
                                         style="max-width:100%;max-height:130px;object-fit:contain;">
                                </div>
                                <div class="small text-muted mt-1">
                                    Ditandatangani oleh:
                                    <strong><?= esc($exists->signer_name ?? '-') ?></strong><br>
                                    Pada:
                                    <strong><?= esc($exists->signed_at ?? '-') ?></strong>
                                </div>
                            </div>
                        <?php else: ?>
                            <p class="small text-muted">
                                Belum ada tanda tangan tersimpan untuk slot ini.
                            </p>
                        <?php endif; ?>

                        <?php if (in_array($slot, ['CHECK','CONFIRM','APPROVE'], true)): ?>
                            <hr>
                            <div class="form-group mt-2">
                                <label for="note"><strong>Catatan / Note (opsional)</strong></label>
                                <textarea name="note" id="note"
                                          class="form-control"
                                          rows="3"
                                          maxlength="500"
                                          placeholder="Tulis catatan untuk laporan ini, misalnya temuan atau instruksi. Boleh dikosongkan."></textarea>
                                <small class="text-muted">
                                    Catatan ini akan muncul di laporan cetak sebagai note untuk
                                    <?= esc($slot); ?>.
                                </small>
                            </div>
                        <?php endif; ?>

                        <div class="alert alert-info small mb-0 mt-2">
                            <strong>Catatan:</strong> Anda hanya perlu memilih salah satu dari
                            tiga opsi di sebelah kiri (canvas / upload / tanda tangan tersimpan),
                            kemudian klik tombol yang sesuai.<br>
                            Sistem otomatis akan mendeteksi mode yang digunakan.
                        </div>
                    </div>
                </div>
            </form>

        </div>
    </div>
</div>

<!-- ==== SCRIPT CANVAS & OPSI 3 ==== -->
<script>
(function() {
    var canvas = document.getElementById('sigCanvas');
    if (!canvas) return;

    var ctx      = canvas.getContext('2d');
    var drawing  = false;
    var lastPos  = {x:0, y:0};

    function getPos(e) {
        var rect = canvas.getBoundingClientRect();
        var x, y;

        if (e.touches && e.touches.length) {
            x = e.touches[0].clientX - rect.left;
            y = e.touches[0].clientY - rect.top;
        } else {
            x = e.clientX - rect.left;
            y = e.clientY - rect.top;
        }
        return {x:x, y:y};
    }

    function startDraw(e) {
        e.preventDefault();
        drawing = true;
        lastPos = getPos(e);
    }

    function endDraw(e) {
        e && e.preventDefault();
        drawing = false;
    }

    function moveDraw(e) {
        if (!drawing) return;
        e.preventDefault();
        var pos = getPos(e);
        ctx.beginPath();
        ctx.moveTo(lastPos.x, lastPos.y);
        ctx.lineTo(pos.x, pos.y);
        ctx.strokeStyle = '#000';
        ctx.lineWidth   = 2;
        ctx.lineCap     = 'round';
        ctx.lineJoin    = 'round';
        ctx.stroke();
        ctx.closePath();
        lastPos = pos;
    }

    // mouse
    canvas.addEventListener('mousedown', startDraw, false);
    canvas.addEventListener('mouseup',   endDraw,   false);
    canvas.addEventListener('mouseout',  endDraw,   false);
    canvas.addEventListener('mousemove', moveDraw,  false);

    // touch
    canvas.addEventListener('touchstart', startDraw, false);
    canvas.addEventListener('touchend',   endDraw,   false);
    canvas.addEventListener('touchcancel',endDraw,   false);
    canvas.addEventListener('touchmove',  moveDraw,  false);

    // clear
    var btnClear = document.getElementById('btn-clear-canvas');
    if (btnClear) {
        btnClear.addEventListener('click', function(e) {
            e.preventDefault();
            ctx.clearRect(0, 0, canvas.width, canvas.height);
        }, false);
    }

    // save from canvas (opsi 1)
    var btnSaveCanvas = document.getElementById('btn-save-canvas');
    if (btnSaveCanvas) {
        btnSaveCanvas.addEventListener('click', function(e) {
            e.preventDefault();
            var dataUrl = canvas.toDataURL('image/png');
            document.getElementById('image_data').value = dataUrl;

            // pastikan flag stored = 0
            var hiddenStored = document.getElementById('use_stored');
            if (hiddenStored) {
                hiddenStored.value = '0';
            }

            document.getElementById('form-sign').submit();
        }, false);
    }

    // OPSI 3: gunakan tanda tangan tersimpan
    var btnStored = document.getElementById('btn-use-stored');
    if (btnStored) {
        btnStored.addEventListener('click', function (e) {
            e.preventDefault();
            var f = document.getElementById('form-sign');
            if (!f) return;

            var hiddenStored = document.getElementById('use_stored');
            if (hiddenStored) {
                hiddenStored.value = '1';
            }

            // kosongkan image_data agar tidak dianggap canvas
            var imgData = document.getElementById('image_data');
            if (imgData) {
                imgData.value = '';
            }

            f.submit();
        }, false);
    }
})();
</script>
