<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<!-- Judul halaman -->
<h1 class="h3 mb-4 text-gray-800">Verifikasi Surat Jalan</h1>

<!-- Nama PIC -->
<div class="card shadow mb-4">
  <div class="card-body">
    <div class="form-group mb-0">
      <label class="font-weight-bold mb-1">Nama PIC</label>
      <input type="text" class="form-control w-auto" value="<?= htmlentities($nama_pic) ?>" readonly>
    </div>
  </div>
</div>

<!-- Filter Tanggal + Dropdown SJ -->
<div class="card shadow mb-4">
  <div class="card-body">
    <form method="get" action="<?= site_url('scan') ?>" class="form-row align-items-end">
      <div class="form-group col-md-3">
        <label class="mb-1">Dari Tanggal</label>
        <input type="date" class="form-control" name="from" value="<?= htmlentities($selected_from ?? '') ?>" required>
      </div>
      <div class="form-group col-md-3">
        <label class="mb-1">Sampai Tanggal</label>
        <input type="date" class="form-control" name="to" value="<?= htmlentities($selected_to ?? '') ?>" required>
      </div>

      <?php if (!empty($sj_list)): ?>
      <div class="form-group col-md-4">
        <label class="mb-1">Pilih Surat Jalan</label>
        <select name="sj_number" class="form-control" onchange="this.form.submit()" required>
          <option value="">-- Pilih SJ --</option>
          <?php foreach ($sj_list as $sj): ?>
            <option value="<?= htmlentities($sj->SJ_number) ?>" <?= ($sj_number === $sj->SJ_number) ? 'selected' : '' ?>>
              <?= htmlentities($sj->SJ_number) ?>
            </option>
          <?php endforeach; ?>
        </select>
      </div>
      <?php endif; ?>

      <div class="form-group col-md-2">
        <button type="submit" class="btn btn-primary btn-block">Cari SJ</button>
      </div>
    </form>
  </div>
</div>

<!-- Form Scan -->
<?php if (!empty($sj_number)): ?>
<div class="card shadow mb-3">
  <div class="card-body">
    <form method="post" action="<?= site_url('scan/submit_scan') ?>" id="scanForm"
          class="<?= $this->session->flashdata('scan_error') ? 'scan-error' : '' ?>">
      <input type="hidden" name="sj_number" value="<?= htmlentities($sj_number) ?>">
      <input type="hidden" name="from"      value="<?= htmlentities($selected_from) ?>">
      <input type="hidden" name="to"        value="<?= htmlentities($selected_to) ?>">

      <div class="form-row">
        <div class="form-group col-md-6 mb-0">
          <label class="mb-1">Scan QR Code</label>
          <input type="text" name="product_code" id="product_code" class="form-control"
                 placeholder="Scan QR di sini..." required autofocus>
        </div>
      </div>
    </form>

    <div class="mt-3 d-flex">
      <form action="<?= site_url("scan/reset_scan/".rawurlencode($sj_number)) ?>" method="post"
            onsubmit="return confirm('Yakin ingin reset scan?')" class="mr-2">
        <button class="btn btn-danger">Reset Qty Scanned</button>
      </form>

      <a class="btn btn-outline-success"
         href="<?= site_url('scan/trigger_complete').'?'.http_build_query([
               'sj_number'=>$sj_number,'from'=>$selected_from,'to'=>$selected_to
             ]) ?>">
        Check Verifikasi Surat Jalan
      </a>
    </div>
  </div>
</div>
<?php endif; ?>

<!-- Tabel Detail -->
<?php if (!empty($sj_data)): ?>
<div class="card shadow mb-4">
  <div class="card-header py-3">
    <h6 class="m-0 font-weight-bold text-primary">
      Detail Produk (SJ: <strong><?= htmlentities($sj_number) ?></strong>)
    </h6>
  </div>
  <div class="card-body">
    <div class="table-responsive">
      <table class="table table-striped table-bordered align-middle">
        <thead class="thead-light text-center">
          <tr>
            <th>Product Code</th>
            <th>Product Name</th>
            <th>Qty (SJ)</th>
            <th>Qty Scanned</th>
          </tr>
        </thead>
        <tbody>
          <?php
            $last_code      = $this->session->flashdata('last_scanned_code') ?? '';
            $total_sj       = 0;
            $total_scanned  = 0;
          ?>
          <?php foreach ($sj_data as $row): ?>
            <?php
              $is_fulfilled     = ($row->scanned_qty >= $row->SJ_qty);
              $is_last_scanned  = ($row->Product_code === $last_code);
              $row_class        = $is_fulfilled ? 'table-success' : ($is_last_scanned ? 'highlight-last' : '');
              $total_sj        += (int)$row->SJ_qty;
              $total_scanned   += (int)$row->scanned_qty;
            ?>
            <tr class="text-center <?= $row_class ?>">
              <td><?= htmlentities($row->Product_code) ?></td>
              <td class="text-left"><?= htmlentities($row->Product_name) ?></td>
              <td><?= number_format((float)$row->SJ_qty, 0) ?></td>
              <td><?= number_format((float)$row->scanned_qty, 0) ?></td>
            </tr>
          <?php endforeach; ?>
        </tbody>
        <tfoot class="thead-light text-center font-weight-bold">
          <tr>
            <td colspan="2">TOTAL</td>
            <td><?= number_format($total_sj, 0) ?></td>
            <td><?= number_format($total_scanned, 0) ?></td>
          </tr>
        </tfoot>
      </table>
    </div>
  </div>
</div>
<?php endif; ?>

<style>
/* gaya kecil yang kamu pakai sebelumnya */
.scan-error input { background-color:#f8d7da !important; border-color:#f5c2c7; }
tr.table-success td { background-color:#d4edda !important; }
tr.highlight-last td { background-color:#fff3cd !important; }
</style>
