<div class="card shadow mb-4">
  <div class="card-header py-3 d-flex justify-content-between align-items-center">
    <h6 class="m-0 font-weight-bold text-success">
      Detail Form Gesek - <?= strtoupper($form['no_pol']); ?>
    </h6>

     <div class="btn-group flex-wrap" role="group" style="gap:6px;">
    <a href="<?= base_url('admin/data_gesek'); ?>" class="btn btn-secondary btn-sm">
      <i class="fas fa-arrow-left"></i> Kembali
    </a>

    <a href="<?= base_url('admin/download_pdf/'.$form['id']); ?>" class="btn btn-success btn-sm">
      <i class="fas fa-download"></i> Download
    </a>

    <a href="<?= base_url('admin/form/edit/'.$form['id']); ?>" class="btn btn-warning btn-sm text-white">
      <i class="fas fa-edit"></i> Edit
    </a>

    <a href="<?= base_url('admin/form/delete/'.$form['id']); ?>" 
       class="btn btn-danger btn-sm btn-delete"
       onclick="return confirm('Yakin ingin menghapus data ini?');">
      <i class="fas fa-trash"></i> Hapus
    </a>
  </div>
  </div>

  <div class="card-body">
    <div class="row">
      <div class="col-md-6">
        <h6 class="text-primary font-weight-bold">Data Kendaraan</h6>
        <table class="table table-sm table-borderless">
          <tr><th width="180">Nomor Polisi</th><td><?= strtoupper($form['no_pol']); ?></td></tr>
          <tr><th>Tipe Kendaraan</th><td><?= strtoupper($form['tipe_kendaraan']); ?></td></tr>
          <tr><th>Nama Pemilik</th><td><?= strtoupper($form['nama_pemilik']); ?></td></tr>
          <tr><th>Pool</th><td><?= strtoupper($form['pool']); ?></td></tr>
        </table>

        <h6 class="text-primary font-weight-bold mt-3">Data Tanggal</h6>
        <table class="table table-sm table-borderless">
          <tr><th>Tanggal In Pool</th><td><?= $form['tgl_inpool'] ? date('d M Y', strtotime($form['tgl_inpool'])) : '-'; ?></td></tr>
          <tr><th>Tanggal Gesek</th><td><?= date('d M Y', strtotime($form['tgl_gesek'])); ?></td></tr>
        </table>

        <h6 class="text-primary font-weight-bold mt-3">Data Teknis</h6>
        <table class="table table-sm table-borderless">
          <tr><th>Nomor Rangka (NOKA)</th><td><?= strtoupper($form['noka']); ?></td></tr>
          <tr><th>Nomor Mesin (NOSIN)</th><td><?= strtoupper($form['nosin']); ?></td></tr>
        </table>
      </div>

      <div class="col-md-6">
        <h6 class="text-primary font-weight-bold">Keterangan</h6>
        <table class="table table-sm table-borderless">
          <tr><th>Keterangan Check</th><td><?= nl2br($form['keterangan_check'] ?? ''); ?></td></tr>
          <tr><th>Keterangan Lain</th><td><?= nl2br($form['keterangan'] ?? ''); ?></td></tr>
        </table>

        <h6 class="text-primary font-weight-bold mt-3">Data Petugas</h6>
        <table class="table table-sm table-borderless">
          <tr><th>Nama Petugas</th><td><?= strtoupper($form['petugas']); ?></td></tr>
          <tr><th>Tanggal Input</th><td><?= date('d M Y H:i', strtotime($form['created_at'])); ?></td></tr>
        </table>
      </div>
    </div>

    <hr>

    <h6 class="text-primary font-weight-bold mb-3">Foto Kendaraan</h6>
    <div class="row text-center">
      <?php 
      $fotos = [
        'foto_noka_nosin' => 'Foto NOKA NOSIN',
        'foto_noka'  => 'Foto Nomor Rangka',
        'foto_nosin' => 'Foto Nomor Mesin'
      ];
      foreach ($fotos as $key => $label): ?>
        <div class="col-md-4 mb-3">
          <div class="card border">
            <div class="card-header bg-success text-white p-2"><?= $label; ?></div>
            <div class="card-body">
              <?php if (!empty($form[$key])): ?>
                <img src="<?= base_url('assets/uploads/'.$form[$key]); ?>" 
                     alt="<?= $label; ?>" class="img-fluid rounded shadow-sm">
              <?php else: ?>
                <span class="text-muted">Tidak ada foto</span>
              <?php endif; ?>
            </div>
          </div>
        </div>
      <?php endforeach; ?>
    </div>
  </div>
</div>


<style>
@media (max-width: 768px) {
  .card-header .btn-group {
    width: 100%;
    display: flex;
    flex-wrap: wrap;
    justify-content: flex-start;
  }
  .card-header .btn-group .btn {
    flex: 1 1 48%;
    margin-bottom: 6px;
  }
}
</style>
