<div class="container-fluid animated--fade-in">

  <!-- Judul -->
  <div class="d-flex justify-content-between align-items-center mb-3 flex-wrap">
    <h1 class="h3 text-gray-800 mb-2"><?= $title; ?></h1>
    <?php if ($this->session->userdata('role') === 'admin'): ?>
      <a href="<?= base_url('admin/user_add'); ?>" class="btn btn-primary btn-sm shadow-sm">
        <i class="fas fa-user-plus"></i> Tambah User
      </a>
    <?php endif; ?>
  </div>

  <!-- Card Tabel -->
  <div class="card shadow border-0 mb-4">
    <div class="card-body p-0">

      <!-- ======= 💻 DESKTOP MODE ======= -->
      <div class="table-responsive d-none d-md-block">
        <table class="table table-hover table-striped mb-0">
          <thead class="bg-primary text-white text-center">
            <tr>
              <th width="40">No</th>
              <th>Nama</th>
              <th>Email</th>
              <th>Role</th>
              <th>Status</th>
              <th>Dibuat</th>
              <?php if ($this->session->userdata('role') === 'admin'): ?>
                <th width="130">Aksi</th>
              <?php endif; ?>
            </tr>
          </thead>
          <tbody class="text-center align-middle">
            <?php if (!empty($users)): ?>
              <?php $no = 1; foreach ($users as $u): ?>
                <tr>
                  <td><?= $no++; ?></td>
                  <td class="text-left font-weight-bold text-primary"><?= strtoupper($u['name']); ?></td>
                  <td class="text-left"><?= $u['email']; ?></td>
                  <td><?= ucfirst($u['role']); ?></td>
                  <td>
                    <?= $u['status'] == 1 
                      ? '<span class="badge badge-success">Aktif</span>'
                      : '<span class="badge badge-secondary">Nonaktif</span>'; ?>
                  </td>
                  <td><?= date('d/m/Y H:i', strtotime($u['created_at'])); ?></td>
                  <?php if ($this->session->userdata('role') === 'admin'): ?>
                    <td>
                      <div class="btn-group" role="group">
                        <a href="<?= base_url('admin/user_edit/'.$u['id']); ?>" 
                           class="btn btn-sm btn-warning" title="Edit">
                           <i class="fas fa-edit"></i>
                        </a>
                        <a href="<?= base_url('admin/user_delete/'.$u['id']); ?>" 
                           class="btn btn-sm btn-danger btn-delete" 
                           data-url="<?= base_url('admin/user_delete/'.$u['id']); ?>" 
                           title="Hapus">
                           <i class="fas fa-trash"></i>
                        </a>
                      </div>
                    </td>
                  <?php endif; ?>
                </tr>
              <?php endforeach; ?>
            <?php else: ?>
              <tr><td colspan="7" class="text-muted text-center">Tidak ada user ditemukan.</td></tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>

      <!-- ======= 📱 MOBILE MODE ======= -->
      <div class="d-md-none p-3">
        <?php if (!empty($users)): ?>
          <?php foreach ($users as $u): ?>
            <div class="card border-left-primary shadow-sm mb-3">
              <div class="card-body py-3 px-3">
                <div class="d-flex justify-content-between align-items-center mb-2">
                  <h6 class="font-weight-bold text-primary mb-0"><?= strtoupper($u['name']); ?></h6>
                  <span class="badge <?= $u['status'] ? 'badge-success' : 'badge-secondary'; ?>">
                    <?= $u['status'] ? 'Aktif' : 'Nonaktif'; ?>
                  </span>
                </div>
                <div class="small text-gray-800 mb-1">
                  <i class="fas fa-envelope text-secondary"></i> <?= $u['email']; ?>
                </div>
                <div class="small text-gray-700 mb-2">
                  <i class="fas fa-user-tag text-info"></i> <?= ucfirst($u['role']); ?>
                </div>
                <div class="small text-gray-500 mb-3">
                  <i class="fas fa-clock"></i> <?= date('d/m/Y H:i', strtotime($u['created_at'])); ?>
                </div>

                <?php if ($this->session->userdata('role') === 'admin'): ?>
                <div class="d-flex justify-content-end">
                  <a href="<?= base_url('admin/user_edit/'.$u['id']); ?>" 
                     class="btn btn-sm btn-warning mr-2">
                    <i class="fas fa-edit"></i>
                  </a>
                  <a href="<?= base_url('admin/user_delete/'.$u['id']); ?>" 
                     class="btn btn-sm btn-danger btn-delete"
                     data-url="<?= base_url('admin/user_delete/'.$u['id']); ?>">
                    <i class="fas fa-trash"></i>
                  </a>
                </div>
                <?php endif; ?>
              </div>
            </div>
          <?php endforeach; ?>
        <?php else: ?>
          <div class="alert alert-light text-center">Belum ada user.</div>
        <?php endif; ?>
      </div>

    </div>
  </div>

</div>

<!-- SweetAlert konfirmasi hapus -->
<script>
document.querySelectorAll('.btn-delete').forEach(btn => {
  btn.addEventListener('click', function(e) {
    e.preventDefault();
    const url = this.getAttribute('data-url');
    Swal.fire({
      title: 'Yakin hapus user ini?',
      text: "Data yang dihapus tidak dapat dikembalikan!",
      icon: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#d33',
      cancelButtonColor: '#6c757d',
      confirmButtonText: 'Ya, hapus!',
      cancelButtonText: 'Batal'
    }).then((result) => {
      if (result.isConfirmed) {
        window.location.href = url;
      }
    });
  });
});
</script>

<style>
/* Animasi lembut */
.animated--fade-in { animation: fadeIn 0.4s ease-in-out; }
@keyframes fadeIn { from {opacity: 0; transform: translateY(5px);} to {opacity: 1; transform: none;} }

/* Style badge dan tabel */
.table th, .table td {
  vertical-align: middle !important;
  font-size: 0.95rem;
}
.badge { font-size: 0.75rem; }

/* Mobile Card Detail */
.card.border-left-primary {
  border-left: 4px solid #4e73df !important;
}
</style>
