
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="utf-8">
    <title>Form Gesek IBID</title>
    <style>
        @page { margin: 25px; }
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            color: #000;
            border: 2px solid #000; /* GARIS LUAR */
            padding: 15px;
        }

        .header {
            text-align: center;
            font-weight: bold;
            font-size: 14px;
            border: 1px solid #000;
            padding: 8px;
            margin-bottom: 8px;
        }

        .table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 6px;
        }

        .table td {
            border: 1px solid #000;
            padding: 6px;
            vertical-align: top;
        }

        .section-title {
            font-weight: bold;
            text-transform: uppercase;
            margin-top: 10px;
            margin-bottom: 3px;
        }

        .photo-box {
            border: 1px solid #000;
            height: 100px;
            width: 100%;
            text-align: center;
            vertical-align: middle;
            font-size: 11px;
        }

        .photo-box img {
            max-width: 100%;
            height: 100px;
            object-fit: cover;
        }

        .sign {
            text-align: right;
            margin-top: 20px;
            font-size: 12px;
        }

        .sign b {
            text-transform: uppercase;
        }

        .photo-title {
            font-weight: bold;
            font-size: 11px;
            border: 1px solid #000;
            padding: 5px;
            text-align: center;
        }
    </style>
</head>
<body>

    <div class="header">FORM GESEK NOKA NOSIN</div>

    <table class="table">
        <tr>
            <td width="50%">
                <b>NOPOL:</b> <?= strtoupper($form['no_pol']); ?><br>
                <b>TIPE:</b> <?= strtoupper($form['tipe_kendaraan']); ?><br>
                <b>PEMILIK:</b> <?= strtoupper($form['nama_pemilik']); ?>
            </td>
            <td width="50%">
                <b>TANGGAL IN POOL:</b> <?= date('d/m/Y', strtotime($form['tgl_inpool'])); ?><br>
                <b>TANGGAL GESEK:</b> <?= date('d/m/Y', strtotime($form['tgl_gesek'])); ?><br>
                <b>POOL:</b> <?= strtoupper($form['pool']); ?>
            </td>
        </tr>
    </table>

    <div class="section-title">DATA TEKNIS</div>
    <table class="table">
        <tr><td><b>NOKA:</b> <?= strtoupper($form['noka']); ?></td></tr>
        <tr><td><b>NOSIN:</b> <?= strtoupper($form['nosin']); ?></td></tr>
    </table>

    <div class="section-title">KETERANGAN</div>
    <table class="table">
        <tr>
            <td width="70%">
                <?= !empty($form['keterangan_check']) ? strtoupper($form['keterangan_check']) : '<i>Tidak ada keterangan khusus.</i>'; ?>
            </td>
            <td width="30%">
                <b>KETERANGAN LAIN:</b><br>
                <?= !empty($form['keterangan']) ? strtoupper($form['keterangan']) : '-'; ?>
            </td>
        </tr>
    </table>

    <div class="sign">
        <?= strtoupper($form['pool']); ?>, <?= date('d F Y'); ?><br><br><br>
        <b><?= strtoupper($form['petugas']); ?></b>
    </div>

    <div class="section-title">DOKUMENTASI FOTO</div>
    <table class="table" style="text-align:center;">
        <tr>
            <td class="photo-title">FOTO NOKA NOSIN</td>
            <td class="photo-title">FOTO NOKA</td>
            <td class="photo-title">FOTO NOSIN</td>
        </tr>
        <tr>
            <?php
                function img_path($file) {
                    if (!empty($file) && file_exists(FCPATH . 'assets/uploads/' . $file)) {
                        // gunakan base64 biar DomPDF pasti bisa tampilkan
                        $path = FCPATH . 'assets/uploads/' . $file;
                        $type = pathinfo($path, PATHINFO_EXTENSION);
                        $data = file_get_contents($path);
                        return 'data:image/' . $type . ';base64,' . base64_encode($data);
                    }
                    return null;
                }
            ?>
            <td class="photo-box">
                <?php if ($img = img_path($form['foto_noka_nosin'])): ?>
                    <img src="<?= $img ?>">
                <?php else: ?>
                    BELUM ADA FOTO
                <?php endif; ?>
            </td>
            <td class="photo-box">
                <?php if ($img = img_path($form['foto_noka'])): ?>
                    <img src="<?= $img ?>">
                <?php else: ?>
                    BELUM ADA FOTO
                <?php endif; ?>
            </td>
            <td class="photo-box">
                <?php if ($img = img_path($form['foto_nosin'])): ?>
                    <img src="<?= $img ?>">
                <?php else: ?>
                    BELUM ADA FOTO
                <?php endif; ?>
            </td>
        </tr>
    </table>

</body>
</html>
