<div class="container-fluid py-3">

  <!-- HEADER -->
  <div class="d-flex justify-content-between align-items-center flex-wrap mb-4">
    <h1 class="h4 fw-bold text-success mb-2">
      <i class="fas fa-chart-line me-2"></i> Laporan Form Gesek
    </h1>
    <small class="text-muted">Filter & Cetak Laporan Berdasarkan Rentang Tanggal</small>
  </div>

  <div class="card shadow-sm border-0">
    <div class="card-body">

      <!-- 🔍 FORM FILTER -->
      <form method="get" action="<?= site_url('laporan'); ?>" class="mb-4">
        <div class="row g-3">
          <div class="col-md-5 col-12">
            <label for="start_date" class="form-label fw-semibold text-secondary">
              <i class="fas fa-calendar-day me-1"></i> Tanggal Mulai
            </label>
            <input
              type="date" id="start_date" name="start_date"
              class="form-control form-control-sm shadow-sm" required
              value="<?= htmlspecialchars($start_date ?: date('Y-m-d'), ENT_QUOTES); ?>">
          </div>

          <div class="col-md-5 col-12">
            <label for="end_date" class="form-label fw-semibold text-secondary">
              <i class="fas fa-calendar-check me-1"></i> Tanggal Akhir
            </label>
            <input
              type="date" id="end_date" name="end_date"
              class="form-control form-control-sm shadow-sm" required
              value="<?= htmlspecialchars($end_date ?: date('Y-m-d'), ENT_QUOTES); ?>">
          </div>

          <div class="col-md-2 col-12 d-flex align-items-end">
            <button type="submit" name="filter" class="btn btn-success w-100 shadow-sm">
              <i class="fas fa-search me-1"></i> Cari
            </button>
          </div>
        </div>
      </form>

      <!-- 📋 HASIL DATA -->
      <?php if (!empty($result)): ?>
        <div class="d-flex justify-content-end flex-wrap gap-2 mb-3">
          <a href="<?= base_url('laporan/export?start=' . urlencode($start_date) . '&end=' . urlencode($end_date)); ?>"
             class="btn btn-info btn-sm shadow-sm text-white">
            <i class="fas fa-file-csv me-1"></i> Export CSV
          </a>
          <a href="<?= base_url('laporan/cetak?start=' . urlencode($start_date) . '&end=' . urlencode($end_date)); ?>"
             class="btn btn-danger btn-sm shadow-sm" target="_blank">
            <i class="fas fa-print me-1"></i> Cetak PDF
          </a>
        </div>

        <!-- Horz scroll by Bootstrap + Vert scroll by .table-scroll -->
        <div class="table-responsive">
          <div class="table-scroll">
            <table class="table table-bordered table-hover align-middle text-nowrap mb-0 table-sticky">
              <thead class="table-success text-center">
                <tr>
                  <!-- No + 10 field sesuai DB (tanpa ID) + kolom 11: keterangan -->
                  <th style="min-width:60px;width:60px;">No</th>
                  <th style="min-width:140px;">No Polisi</th>
                  <th style="min-width:160px;">Tipe Kendaraan</th>
                  <th style="min-width:180px;">Nama Pemilik</th>
                  <th style="min-width:120px;">Pool</th>
                  <th style="min-width:120px;">Tgl Inpool</th>
                  <th style="min-width:120px;">Tgl Gesek</th>
                  <th style="min-width:200px;">NOKA</th>
                  <th style="min-width:160px;">NOSIN</th>
                  <th style="min-width:220px;">Keterangan Check</th>
                  <th style="min-width:220px;">Keterangan</th>
                </tr>
              </thead>
              <tbody>
                <?php $no = 1; foreach ($result as $r): ?>
                  <?php
                    $no_pol  = strtoupper($r['no_pol'] ?? '');
                    $tipe    = strtoupper($r['tipe_kendaraan'] ?? '');
                    $pemilik = strtoupper($r['nama_pemilik'] ?? '');
                    $pool    = strtoupper($r['pool'] ?? '');
                    $inpool  = !empty($r['tgl_inpool']) ? date('d/m/Y', strtotime($r['tgl_inpool'])) : '-';
                    $gesek   = !empty($r['tgl_gesek'])  ? date('d/m/Y', strtotime($r['tgl_gesek']))  : '-';
                    $noka    = strtoupper($r['noka'] ?? '');
                    $nosin   = strtoupper($r['nosin'] ?? '');
                    $ketc    = $r['keterangan_check'] ?? '';
                    $ket     = $r['keterangan'] ?? '';
                  ?>
                  <tr>
                    <td class="text-center fw-semibold"><?= $no++; ?></td>
                    <td class="fw-semibold"><?= htmlspecialchars($no_pol ?: '-', ENT_QUOTES); ?></td>
                    <td><?= htmlspecialchars($tipe ?: '-', ENT_QUOTES); ?></td>
                    <td><?= htmlspecialchars($pemilik ?: '-', ENT_QUOTES); ?></td>
                    <td class="text-primary fw-semibold"><?= htmlspecialchars($pool ?: '-', ENT_QUOTES); ?></td>
                    <td class="text-center"><?= htmlspecialchars($inpool, ENT_QUOTES); ?></td>
                    <td class="text-center"><?= htmlspecialchars($gesek, ENT_QUOTES); ?></td>
                    <td class="text-monospace wrap-anywhere"><?= htmlspecialchars($noka ?: '-', ENT_QUOTES); ?></td>
                    <td class="text-monospace wrap-anywhere"><?= htmlspecialchars($nosin ?: '-', ENT_QUOTES); ?></td>
                    <td class="wrap-anywhere"><?= htmlspecialchars($ketc ?: '-', ENT_QUOTES); ?></td>
                    <td class="wrap-anywhere"><?= htmlspecialchars($ket ?: '-', ENT_QUOTES); ?></td>
                  </tr>
                <?php endforeach; ?>
              </tbody>
            </table>
          </div>
        </div>

      <?php else: ?>
        <div class="alert alert-info mt-4 text-center shadow-sm py-3">
          <i class="fas fa-info-circle me-1"></i>
          Tidak ada data pada rentang tanggal ini.
        </div>
      <?php endif; ?>

    </div>
  </div>
</div>

<!-- 🌈 STYLING -->
<style>
  h1.h4 { letter-spacing: .5px; }
  .table thead th { font-size: .9rem; letter-spacing: .3px; }
  .table td { font-size: .88rem; }
  .btn i { vertical-align: middle; }
  .form-label { font-size: .85rem; }

  /* Kontainer scroll vertikal untuk tabel */
  .table-scroll{
    max-height: 50vh;      /* tinggi viewport tabel */
    overflow-y: auto;      /* body tabel yg scroll */
    overflow-x: hidden;    /* horz scroll tetap via .table-responsive */
  }

  /* Sticky header nempel ke atas .table-scroll */
  .table-sticky thead th{
    position: sticky;
    top: 0;
    z-index: 2;
    background: #d1e7dd;   /* samakan dg .table-success */
  }

  /* Teks panjang rapi */
  .wrap-anywhere{
    word-break: break-word;
    overflow-wrap: anywhere;
    white-space: normal;
  }
  .text-monospace{
    font-family: ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono", "Courier New", monospace;
  }

  @media (max-width: 768px){
    .table td, .table th{ font-size:.8rem; }
    .table{ table-layout:auto; }
  }
</style>
