<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <title><?= htmlspecialchars($title ?? 'Laporan Form Gesek', ENT_QUOTES); ?></title>
  <style>
    /* Halaman */
    @page { size: A4 landscape; margin: 15mm 10mm; }

    /* Typography */
    body { font-family: DejaVu Sans, Arial, Helvetica, sans-serif; font-size: 10.5px; color:#000; }

    /* Tabel */
    table { width:100%; border-collapse: collapse; table-layout: fixed; }
    thead { display: table-header-group; }   /* header diulang tiap halaman */
    th, td { border:1px solid #000; padding:4px 5px; vertical-align: middle; line-height:1.2; }
    th { background:#e6f4ea; text-align:center; font-weight:700; }
    td { text-align:left; }
    td.text-center { text-align:center; }
    .mono { font-family: "DejaVu Sans Mono", Consolas, Menlo, monospace; }
    .nowrap { white-space: nowrap; }
    .wrap-anywhere { word-break: break-word; overflow-wrap: anywhere; white-space: normal; }
    tbody tr:nth-child(odd){ background:#fafafa; }

    /* Kolom pakai persen (total 100%) */
    col.no      { width: 4%;  }
    col.nopol   { width: 9%;  }
    col.tipe    { width:10%;  }
    col.pemilik { width:12%;  }
    col.pool    { width: 8%;  }
    col.tglin   { width: 8%;  }
    col.tglge   { width: 8%;  }
    col.noka    { width:13%;  }
    col.nosin   { width:11%;  }
    col.ketc    { width: 8%;  }
    col.ket     { width: 9%;  }

    /* Hindari baris pecah aneh */
    tr { page-break-inside: avoid; }
    /* Hilangkan spasi aneh sebelum tabel */
    table { margin:0; }
  </style>
</head>
<body>

  <table>
    <colgroup>
      <col class="no"><col class="nopol"><col class="tipe"><col class="pemilik">
      <col class="pool"><col class="tglin"><col class="tglge">
      <col class="noka"><col class="nosin"><col class="ketc"><col class="ket">
    </colgroup>

    <thead>
      <!-- Baris judul (merge 11 kolom) -->
      <tr>
        <th colspan="11" style="background:#fff;border-color:#fff;font-size:14px;">
          <div style="font-weight:700;">LAPORAN FORM GESEK</div>
          <div style="font-weight:400;font-size:10.5px;color:#555;margin-top:2px;">
            Periode:
            <?= htmlspecialchars(!empty($start) ? date('d/m/Y', strtotime($start)) : '-', ENT_QUOTES); ?>
            – <?= htmlspecialchars(!empty($end) ? date('d/m/Y', strtotime($end)) : '-', ENT_QUOTES); ?>
          </div>
        </th>
      </tr>
      <!-- Baris header kolom -->
      <tr>
        <th>No</th>
        <th>No Polisi</th>
        <th>Tipe Kendaraan</th>
        <th>Nama Pemilik</th>
        <th>Pool</th>
        <th>Tgl Inpool</th>
        <th>Tgl Gesek</th>
        <th>NOKA</th>
        <th>NOSIN</th>
        <th>Keterangan Check</th>
        <th>Keterangan</th>
      </tr>
    </thead>

    <tbody>
      <?php
        $no=1;
        if (!empty($result)):
          foreach ($result as $r):
            $no_pol  = strtoupper((string)($r['no_pol'] ?? ''));
            $tipe    = strtoupper((string)($r['tipe_kendaraan'] ?? ''));
            $pemilik = strtoupper((string)($r['nama_pemilik'] ?? ''));
            $pool    = strtoupper((string)($r['pool'] ?? ''));
            $tgl_in  = !empty($r['tgl_inpool']) ? date('d/m/Y', strtotime($r['tgl_inpool'])) : '-';
            $tgl_ge  = !empty($r['tgl_gesek'])  ? date('d/m/Y', strtotime($r['tgl_gesek']))  : '-';
            $noka    = strtoupper((string)($r['noka'] ?? ''));
            $nosin   = strtoupper((string)($r['nosin'] ?? ''));
            $ketc    = (string)($r['keterangan_check'] ?? '');
            $ket     = (string)($r['keterangan'] ?? '');
      ?>
      <tr>
        <td class="text-center"><?= $no++; ?></td>
        <td class="nowrap"><?= htmlspecialchars($no_pol ?: '-', ENT_QUOTES); ?></td>
        <td><?= htmlspecialchars($tipe ?: '-', ENT_QUOTES); ?></td>
        <td><?= htmlspecialchars($pemilik ?: '-', ENT_QUOTES); ?></td>
        <td class="nowrap"><?= htmlspecialchars($pool ?: '-', ENT_QUOTES); ?></td>
        <td class="text-center nowrap"><?= htmlspecialchars($tgl_in, ENT_QUOTES); ?></td>
        <td class="text-center nowrap"><?= htmlspecialchars($tgl_ge, ENT_QUOTES); ?></td>
        <td class="mono wrap-anywhere"><?= htmlspecialchars($noka ?: '-', ENT_QUOTES); ?></td>
        <td class="mono wrap-anywhere"><?= htmlspecialchars($nosin ?: '-', ENT_QUOTES); ?></td>
        <td class="wrap-anywhere"><?= htmlspecialchars($ketc ?: '-', ENT_QUOTES); ?></td>
        <td class="wrap-anywhere"><?= htmlspecialchars($ket ?: '-', ENT_QUOTES); ?></td>
      </tr>
      <?php
          endforeach;
        else:
      ?>
      <tr>
        <td colspan="11" class="text-center">Tidak ada data pada periode ini.</td>
      </tr>
      <?php endif; ?>
    </tbody>
  </table>

</body>
</html>
