<nav class="navbar navbar-expand navbar-light bg-white topbar mb-4 static-top shadow">

  <!-- Tombol Toggle Sidebar -->
  <button id="sidebarToggle" class="btn btn-link rounded-circle mr-3">
    <i class="fa fa-bars"></i>
  </button>

  <!-- Navbar kanan -->
  <ul class="navbar-nav ml-auto align-items-center">

    <!-- ===================== -->
    <!-- 🔹 Badge Role Login -->
    <!-- ===================== -->
    <?php
      $role = $this->session->userdata('role');
      $badgeClass = [
        'admin' => 'badge-danger',
        'inspector' => 'badge-info',
        'user' => 'badge-success'
      ][$role] ?? 'badge-secondary';
    ?>
    <li class="nav-item mr-2">
      <span class="badge <?= $badgeClass; ?> text-uppercase px-3 py-2 shadow-sm role-badge">
        <i class="fas fa-user-shield mr-1"></i>
        <?= ucfirst($role); ?>
      </span>
    </li>

    <!-- Divider -->
    <div class="topbar-divider d-none d-sm-block"></div>

    <!-- User Dropdown -->
    <li class="nav-item dropdown no-arrow">
      <a 
        class="nav-link dropdown-toggle d-flex align-items-center" 
        href="#" 
        id="userDropdown" 
        role="button" 
        data-toggle="dropdown" 
        aria-haspopup="true" 
        aria-expanded="false"
      >
        <div class="text-right mr-2 user-info">
          <div class="text-gray-800 small font-weight-bold username">
            <?= $this->session->userdata('name'); ?>
          </div>
          <div class="text-gray-500 small userrole">
            <?= ucfirst($this->session->userdata('role')); ?>
          </div>
        </div>
        <img 
          class="img-profile rounded-circle border border-success shadow-sm" 
          src="<?= base_url('assets/img/undraw_profile.svg'); ?>" 
          alt="Profile" 
          style="width: 36px; height: 36px; object-fit: cover;"
        >
      </a>

      <!-- Dropdown Menu -->
      <div 
        class="dropdown-menu dropdown-menu-right shadow animated--grow-in" 
        aria-labelledby="userDropdown"
      >
        <a class="dropdown-item" href="<?= base_url('auth/logout'); ?>" onclick="return confirm('Yakin ingin logout?');">
          <i class="fas fa-sign-out-alt fa-sm fa-fw mr-2 text-gray-400"></i>
          Logout
        </a>
      </div>
    </li>
  </ul>
</nav>

<!-- =====================
     🎨 STYLING
===================== -->
<style>
/* --- Badge Role --- */
.role-badge {
  font-weight: 600;
  font-size: 0.8rem;
  letter-spacing: 0.5px;
}

/* --- Username & Role Info --- */
.user-info {
  display: flex;
  flex-direction: column;
  align-items: flex-end;
}
.username {
  font-size: 0.85rem;
  font-weight: 600;
  color: #333;
}
.userrole {
  font-size: 0.75rem;
  color: #6c757d;
}

/* --- Responsif Mobile --- */
@media (max-width: 768px) {
  .navbar {
    padding: 0.5rem 1rem;
  }

  .role-badge {
    font-size: 0.7rem;
    padding: 4px 8px;
  }

  .user-info {
    align-items: flex-start;
    text-align: left;
  }

  .username {
    font-size: 0.8rem;
  }

  .userrole {
    font-size: 0.7rem;
  }

  .img-profile {
    width: 34px !important;
    height: 34px !important;
  }
}
</style>
