<!-- =============================
     FORM LIST VIEW (DESKTOP & MOBILE)
     NOTE: Header/Topbar/Sidebar/Footer loaded from template.php
============================= -->

<div class="container-fluid px-3 px-md-4 py-3">

  <!-- 🌐 DESKTOP VIEW (>= md) -->
  <div class="d-none d-md-block">
    <div class="d-flex justify-content-between align-items-center mb-3">
      <h4 class="text-success font-weight-bold mb-0">Data Form Gesek</h4>
      <a href="<?= base_url('form/add'); ?>" class="btn btn-success btn-sm">
        <i class="fas fa-plus"></i> Tambah Data
      </a>
    </div>

    <!-- 🔍 Pencarian -->
    <div class="card mb-3 shadow-sm">
      <div class="card-body">
        <form method="get" action="<?= base_url('form'); ?>" class="form-inline">
          <input
            type="text"
            name="q"
            value="<?= $this->input->get('q'); ?>"
            class="form-control mr-2 mb-2 mb-sm-0"
            placeholder="Cari Nopol, Pemilik, atau Tipe Kendaraan..."
            style="max-width:420px"
            aria-label="Kata kunci"
          >
          <button type="submit" class="btn btn-success mr-2 mb-2 mb-sm-0">
            <i class="fas fa-search"></i> Cari
          </button>
          <a href="<?= base_url('form'); ?>" class="btn btn-outline-secondary mb-2 mb-sm-0">
            <i class="fas fa-sync-alt"></i> Reset
          </a>
        </form>
      </div>
    </div>

    <!-- 📋 Tabel Data -->
    <div class="card shadow">
      <div class="card-body">
        <div class="table-responsive">
          <table class="table table-bordered table-hover mb-0">
            <thead class="bg-success text-white text-center">
              <tr>
                <th style="width:48px">#</th>
                <th>No Polisi</th>
                <th>Tipe Kendaraan</th>
                <th>Nama Pemilik</th>
                <th>Tanggal Gesek</th>
                <th>Petugas</th>
                <th style="width:160px">Aksi</th>
              </tr>
            </thead>
            <tbody>
              <?php if (!empty($forms)): ?>
                <?php $no = 1; foreach ($forms as $f): ?>
                  <tr>
                    <td class="text-center align-middle"><?= $no++; ?></td>
                    <td class="align-middle"><b><?= strtoupper($f['no_pol']); ?></b></td>
                    <td class="align-middle"><?= strtoupper($f['tipe_kendaraan']); ?></td>
                    <td class="align-middle"><?= strtoupper($f['nama_pemilik']); ?></td>
                    <td class="align-middle"><?= date('d M Y', strtotime($f['tgl_gesek'])); ?></td>
                    <td class="align-middle"><?= strtoupper($f['petugas']); ?></td>
                    <td class="text-center align-middle">
                      <div class="btn-group" role="group" aria-label="Aksi">
                        <a href="<?= base_url('form/detail/'.$f['id']); ?>"
                           class="btn btn-sm btn-outline-info"
                           data-toggle="tooltip" title="Lihat Detail" aria-label="Lihat Detail">
                          <i class="fas fa-eye"></i>
                        </a>
                        <a href="<?= base_url('form/print/'.$f['id']); ?>"
                           class="btn btn-sm btn-outline-primary"
                           target="_blank" data-toggle="tooltip" title="Download PDF" aria-label="Download PDF">
                          <i class="fas fa-download"></i>
                        </a>
                        <a href="<?= base_url('form/share/'.$f['id']); ?>"
                           class="btn btn-sm btn-outline-success"
                           data-toggle="tooltip" title="Bagikan" aria-label="Bagikan">
                          <i class="fas fa-share-alt"></i>
                        </a>
                        <a href="<?= base_url('form/print/'.$f['id']); ?>"
                           class="btn btn-sm btn-outline-warning"
                           target="_blank" data-toggle="tooltip" title="Cetak" aria-label="Cetak">
                          <i class="fas fa-print"></i>
                        </a>
                      </div>
                    </td>
                  </tr>
                <?php endforeach; ?>
              <?php else: ?>
                <tr>
                  <td colspan="7" class="text-center text-muted py-3">
                    <i class="fas fa-info-circle"></i> Tidak ada data ditemukan.
                  </td>
                </tr>
              <?php endif; ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>


  <!-- 📱 MOBILE VIEW (< md) -->
  <div class="d-md-none">

    <!-- ❌ (Dihapus) Header Compact supaya tidak dobel topbar -->

    <div class="mt-2 px-0">

      <!-- Bar atas -->
      <div class="d-flex justify-content-between align-items-center mb-2 px-2">
        <div>
          <h6 class="font-weight-bold mb-0">Data Form Gesek</h6>
          <small class="text-muted"><?= (int)count($forms); ?> data ditemukan</small>
        </div>
        <a href="<?= base_url('form/add'); ?>" class="btn btn-success btn-sm rounded-pill px-3">
          <i class="fas fa-plus mr-1"></i> Tambah
        </a>
      </div>

      <!-- Search minimal -->
      <form method="get" action="<?= base_url('form'); ?>" class="mb-3 px-2">
        <div class="input-group shadow-sm rounded overflow-hidden">
          <input
            type="text"
            name="q"
            value="<?= $this->input->get('q'); ?>"
            class="form-control border-0"
            placeholder="Cari nopol, pemilik, tipe, noka, nosin…"
            aria-label="Kata kunci"
          >
          <div class="input-group-append">
            <button type="submit" class="btn btn-success" aria-label="Cari">
              <i class="fas fa-search"></i>
            </button>
            <a href="<?= base_url('form'); ?>" class="btn btn-outline-secondary" aria-label="Reset pencarian">
              <i class="fas fa-sync-alt"></i>
            </a>
          </div>
        </div>
      </form>

      <!-- Kartu data (full width) -->
      <?php if (!empty($forms)): ?>
        <?php foreach ($forms as $f): ?>
          <?php
            $no_pol   = strtoupper($f['no_pol'] ?? '-');
            $tipe     = strtoupper($f['tipe_kendaraan'] ?? '-');
            $pemilik  = strtoupper($f['nama_pemilik'] ?? '-');
            $tglRaw   = $f['tgl_gesek'] ?? null;
            $tglShort = $tglRaw ? date('d M Y', strtotime($tglRaw)) : '-';
            $tglLong  = $tglRaw ? date('d F Y', strtotime($tglRaw)) : '-';
            $lokasi   = strtoupper($f['pool'] ?? $f['lokasi'] ?? '-');
            $petugas  = strtoupper($f['petugas'] ?? '-');

            $uploads  = base_url('assets/uploads/');
            if (!empty($f['foto_noka_nosin'])) {
              $foto = $uploads . $f['foto_noka_nosin'];
            } elseif (!empty($f['foto_noka'])) {
              $foto = $uploads . $f['foto_noka'];
            } elseif (!empty($f['foto_nosin'])) {
              $foto = $uploads . $f['foto_nosin'];
            } else {
              $foto = base_url('assets/img/noimage.png');
            }

            $tagSrc = $f['keterangan_check'] ?? $f['keterangan'] ?? '';
            $tags   = array_filter(array_map('trim', preg_split('/[,;|]/', (string)$tagSrc)));
          ?>

          <div class="card shadow-sm border-0 mb-3 rounded-lg mobile-card-edge">
            <div class="card-body p-3">

              <div class="d-flex justify-content-between">
                <div class="d-flex align-items-center">
                  <img src="<?= $foto; ?>" class="rounded mr-2 mobile-thumb" width="56" height="56" alt="foto">
                  <div>
                    <h6 class="font-weight-bold mb-0 text-success"><?= $no_pol; ?></h6>
                    <small class="text-muted d-block"><?= $tipe; ?></small>
                  </div>
                </div>
                <small class="text-muted"><?= $tglShort; ?></small>
              </div>

              <div class="mt-2">
                <div class="mb-1">
                  <i class="fas fa-user text-muted icon-gap"></i><span><?= $pemilik; ?></span>
                </div>
                <div class="mb-1">
                  <i class="fas fa-map-marker-alt text-muted icon-gap"></i><span><?= $lokasi; ?></span>
                </div>
                <div class="mb-0">
                  <i class="fas fa-calendar text-muted icon-gap"></i><span>Gesek: <?= $tglLong; ?></span>
                </div>
              </div>

              <?php if (!empty($tags)): ?>
                <div class="mt-2">
                  <?php foreach ($tags as $t): ?>
                    <span class="badge badge-light border mr-1 mb-1"><?= htmlspecialchars($t); ?></span>
                  <?php endforeach; ?>
                </div>
              <?php endif; ?>

              <div class="mt-3 d-flex justify-content-between align-items-center">
                <small class="text-muted">Petugas: <?= $petugas; ?></small>

                <div class="d-flex align-items-center">
                  <a href="<?= base_url('form/detail/'.($f['id'] ?? '')); ?>"
                     class="btn btn-sm btn-outline-info action-btn" title="Detail" aria-label="Detail">
                    <i class="fas fa-eye"></i>
                  </a>
                  <a href="<?= base_url('form/print/'.($f['id'] ?? '')); ?>"
                     class="btn btn-sm btn-outline-primary action-btn"
                     title="Download" aria-label="Download" target="_blank">
                    <i class="fas fa-download"></i>
                  </a>
                  <a href="<?= base_url('form/share/'.($f['id'] ?? '')); ?>"
                     class="btn btn-sm btn-outline-success action-btn" title="Share" aria-label="Share">
                    <i class="fas fa-share-alt"></i>
                  </a>
                  <a href="<?= base_url('form/print/'.($f['id'] ?? '')); ?>"
                     class="btn btn-sm btn-outline-warning action-btn"
                     title="Print" aria-label="Print" target="_blank">
                    <i class="fas fa-print"></i>
                  </a>
                </div>
              </div>

            </div>
          </div>
        <?php endforeach; ?>
      <?php else: ?>
        <div class="text-center text-muted py-3">
          <i class="fas fa-info-circle"></i> Tidak ada data ditemukan.
        </div>
      <?php endif; ?>

    </div>
  </div>
</div>

<!-- 🔘 Modal Filter -->
<div class="modal fade" id="filterModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <form method="get" action="<?= base_url('form'); ?>" class="modal-content rounded-lg border-0 shadow-sm">
      <div class="modal-header border-0">
        <h6 class="modal-title text-success"><i class="fas fa-filter mr-2"></i>Filter Data</h6>
        <button type="button" class="close" data-dismiss="modal" aria-label="Tutup"><span>&times;</span></button>
      </div>
      <div class="modal-body">
        <label class="font-weight-semibold">Tanggal Mulai</label>
        <input type="date" class="form-control mb-2" name="start_date" value="<?= $this->input->get('start_date'); ?>">
        <label class="font-weight-semibold">Tanggal Akhir</label>
        <input type="date" class="form-control mb-2" name="end_date" value="<?= $this->input->get('end_date'); ?>">
        <label class="font-weight-semibold">Tipe Kendaraan</label>
        <input type="text" class="form-control mb-2" name="tipe" placeholder="Cari berdasarkan tipe..." value="<?= $this->input->get('tipe'); ?>">
        <label class="font-weight-semibold">Petugas</label>
        <input type="text" class="form-control mb-3" name="petugas" placeholder="Cari berdasarkan petugas..." value="<?= $this->input->get('petugas'); ?>">

        <div class="d-flex justify-content-between">
          <a href="<?= base_url('form'); ?>" class="btn btn-outline-secondary w-50 mr-2">
            <i class="fas fa-undo mr-1"></i>Reset
          </a>
          <button class="btn btn-success w-50">
            <i class="fas fa-filter mr-1"></i>Terapkan
          </button>
        </div>
      </div>
    </form>
  </div>
</div>

<!-- 🎨 Styles khusus view -->
<style>
/* ======= Sticky topbar fallback ======= */
/* kalau topbar partial belum pakai .sticky-top, ini bikin tetap nempel */
#content > nav.navbar {
  position: sticky;
  top: 0;
  z-index: 1020; /* di atas konten, di bawah modal backdrop */
}

/* ======= General ======= */
.icon-gap { margin-right: .5rem; }
.action-btn { margin-left: .35rem; }
.table td, .table th { vertical-align: middle; }

/* ======= Mobile cards ======= */
@media (max-width: 767.98px) {
  .mobile-card-edge {
    border-left: 5px solid #198754;
    border-radius: 1rem;
    box-shadow: 0 3px 10px rgba(0,0,0,.06);
    /* full-bleed look */
    margin-left: -12px;
    margin-right: -12px;
  }
  .mobile-thumb { width: 56px; height: 56px; object-fit: cover; }
  .badge { border-radius: 1rem; font-weight: 500; }
  .input-group .form-control { font-size: .95rem; padding: .65rem .85rem; }
}

/* Soft outline colors */
.btn-outline-info, .btn-outline-primary, .btn-outline-success, .btn-outline-warning { border-width: 1px; }
</style>
