<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/userguide3/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/
/*
|--------------------------------------------------------------------------
| Default Route
|--------------------------------------------------------------------------
*/
$route['default_controller']   = 'auth/login_siswa';
$route['404_override']         = '';
$route['translate_uri_dashes'] = FALSE;

/*
|--------------------------------------------------------------------------
| Auth Routes
|--------------------------------------------------------------------------
*/
$route['login_siswa']    = 'auth/login_siswa';
$route['login_admin']    = 'auth/login_admin';
$route['register']       = 'auth/register';
$route['logout']         = 'auth/logout';

// REGISTRASI BARU
$route['register_hsi']   = 'auth/register_hsi';
$route['register_raftel']= 'auth/register_raftel';

// Forgot Password Flow
$route['forgot_password'] = 'auth/forgot_password';
$route['verify_otp']      = 'auth/verify_otp';
$route['reset_password']  = 'auth/reset_password';

/*
|--------------------------------------------------------------------------
| Dashboard
|--------------------------------------------------------------------------
*/
$route['dashboard']          = 'dashboard/index';
$route['dashboard/admin1']   = 'dashboard/admin1';
$route['dashboard/admin2']   = 'dashboard/admin2';
$route['dashboard/user']     = 'dashboard/user';

/*
|--------------------------------------------------------------------------
| Pembayaran Pelatihan (HSI Only)
|--------------------------------------------------------------------------
*/
// siswa
$route['pembayaran_pelatihan']          = 'pembayaran_pelatihan/index';
$route['pembayaran_pelatihan/submit']   = 'pembayaran_pelatihan/submit';

// admin
$route['pembayaran_pelatihan/admin']          = 'pembayaran_pelatihan/admin_index';
$route['pembayaran_pelatihan/detail/(:any)']  = 'pembayaran_pelatihan/detail/$1';
$route['pembayaran_pelatihan/approve/(:num)'] = 'pembayaran_pelatihan/approve/$1';
$route['pembayaran_pelatihan/reject/(:num)']  = 'pembayaran_pelatihan/reject/$1';



/*
|--------------------------------------------------------------------------
| Pembayaran Raftel (All Siswa)
|--------------------------------------------------------------------------
*/
// siswa
$route['pembayaran_raftel']          = 'pembayaran_raftel/index';
$route['pembayaran_raftel/submit']   = 'pembayaran_raftel/submit';

// admin
$route['pembayaran_raftel/admin']           = 'pembayaran_raftel/admin_index';
$route['pembayaran_raftel/approve/(:num)']  = 'pembayaran_raftel/approve/$1';
$route['pembayaran_raftel/reject/(:num)']   = 'pembayaran_raftel/reject/$1';
$route['pembayaran-pelatihan/print-invoice/(:num)']  = 'pembayaran_pelatihan/print_invoice/$1';
$route['pembayaran-pelatihan/print-kwitansi/(:num)'] = 'pembayaran_pelatihan/print_kwitansi/$1';

/*
|--------------------------------------------------------------------------
| Pengaturan Biaya (Admin Only)
|--------------------------------------------------------------------------
*/
$route['biaya']                = 'biaya/index';
$route['biaya/add']            = 'biaya/add';
$route['biaya/edit/(:num)']    = 'biaya/edit/$1';
$route['biaya/delete/(:num)']  = 'biaya/delete/$1';

// (opsional) alias admin untuk konsistensi URL
$route['admin/calon/pembayaran']                 = 'pembayaran_pelatihan/admin_index';
$route['admin/calon/pembayaran/approve/(:num)']  = 'pembayaran_pelatihan/approve/$1';
$route['admin/calon/pembayaran/reject/(:num)']   = 'pembayaran_pelatihan/reject/$1';

/*
|--------------------------------------------------------------------------
| Laporan Keuangan
|--------------------------------------------------------------------------
*/
$route['laporan-keuangan']          = 'laporan_keuangan/index';
$route['laporan-keuangan/pdf']      = 'laporan_keuangan/export_pdf';
$route['laporan-keuangan/excel']    = 'laporan_keuangan/export_excel';
