<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Biaya extends CI_Controller {

    public function __construct() {
        parent::__construct();
        check_role([1,2]); // hanya admin/staff
        $this->load->model('Biaya_model', 'biaya');
        $this->load->library(['form_validation','session']);
        $this->load->helper(['form','url']);
    }

    public function index() {
        $data['title'] = 'Pengaturan Biaya';
        $data['list']  = $this->biaya->get_all();
        $this->load->view('biaya/index', $data);
    }

    public function add() {
        if ($this->input->post()) {
            $this->form_validation->set_rules('Jenis', 'Jenis', 'required');
            $this->form_validation->set_rules('Tahun', 'Tahun', 'required|numeric');
            $this->form_validation->set_rules('Nominal', 'Nominal', 'required|numeric');

            if ($this->form_validation->run() == FALSE) {
                $this->session->set_flashdata('error', validation_errors());
                redirect('biaya');
            }

            $insert = [
                'Jenis'      => $this->input->post('Jenis', true),
                'Negara'     => $this->input->post('Negara', true),
                'Perusahaan' => $this->input->post('Perusahaan', true),
                'Tahun'      => $this->input->post('Tahun', true),
                'Nominal'    => $this->input->post('Nominal', true),
            ];

            $this->biaya->insert($insert);
            $this->session->set_flashdata('success', 'Biaya berhasil ditambahkan.');
            redirect('biaya');
        }
    }

    public function edit($id) {
        if ($this->input->post()) {
            $update = [
                'Jenis'      => $this->input->post('Jenis', true),
                'Negara'     => $this->input->post('Negara', true),
                'Perusahaan' => $this->input->post('Perusahaan', true),
                'Tahun'      => $this->input->post('Tahun', true),
                'Nominal'    => $this->input->post('Nominal', true),
            ];

            $this->biaya->update($id, $update);
            $this->session->set_flashdata('success', 'Biaya berhasil diupdate.');
            redirect('biaya');
        }
    }

    public function delete($id) {
        $this->biaya->delete($id);
        $this->session->set_flashdata('success', 'Biaya berhasil dihapus.');
        redirect('biaya');
    }
}
