<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Laporan_keuangan extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        // Kalau lo punya helper/func auth, panggil di sini
        // is_logged_in();

        $this->load->model('Laporan_keuangan_model', 'laporan');
    }

    public function index()
    {
        $data['title'] = 'Laporan Keuangan Pelatihan';

        // Ambil filter via GET (biar URL bisa di-share)
        $filters = [
            'date_from' => $this->input->get('date_from'),
            'date_to'   => $this->input->get('date_to'),
            'status'    => $this->input->get('status') ?: 'all',
            'metode'    => $this->input->get('metode') ?: 'all',
        ];

        // Default: bulan berjalan
        if (empty($filters['date_from'])) {
            $filters['date_from'] = date('Y-m-01');
        }
        if (empty($filters['date_to'])) {
            $filters['date_to'] = date('Y-m-t');
        }

        $data['filters']    = $filters;
        $data['pembayaran'] = $this->laporan->get_pembayaran($filters);
        $data['rekap']      = $this->laporan->get_rekap_summary($filters);

        $this->load->view('templates/header', $data);
        $this->load->view('templates/sidebar', $data);
        $this->load->view('templates/topbar', $data);
        $this->load->view('laporan_keuangan/index', $data);
        $this->load->view('templates/footer');
    }

    public function export_pdf()
    {
        $filters = [
            'date_from' => $this->input->get('date_from'),
            'date_to'   => $this->input->get('date_to'),
            'status'    => $this->input->get('status') ?: 'all',
            'metode'    => $this->input->get('metode') ?: 'all',
        ];

        $data['title']      = 'Laporan Keuangan Pelatihan';
        $data['filters']    = $filters;
        $data['pembayaran'] = $this->laporan->get_pembayaran($filters);
        $data['rekap']      = $this->laporan->get_rekap_summary($filters);

        // Pakai view khusus untuk pdf (tanpa sidebar/topbar)
        $html = $this->load->view('laporan_keuangan/pdf', $data, TRUE);

        // Sesuaikan dengan library Pdf_maker lo
        $this->load->library('Pdf_maker');
        $this->pdf_maker->generate($html, 'laporan_keuangan_' . date('Ymd_His'));
    }

    public function export_excel()
    {
        $filters = [
            'date_from' => $this->input->get('date_from'),
            'date_to'   => $this->input->get('date_to'),
            'status'    => $this->input->get('status') ?: 'all',
            'metode'    => $this->input->get('metode') ?: 'all',
        ];

        $pembayaran = $this->laporan->get_pembayaran($filters);

        header("Content-Type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"laporan_keuangan_" . date('Ymd_His') . ".xls\"");

        echo "Tanggal\tNama Siswa\tKeterangan\tMetode\tStatus\tJumlah\n";
        foreach ($pembayaran as $row) {
            echo $row['tanggal_bayar'] . "\t"
                . $row['nama_siswa'] . "\t"
                . $row['keterangan'] . "\t"
                . $row['metode_bayar'] . "\t"
                . $row['status'] . "\t"
                . $row['jumlah_bayar'] . "\n";
        }
    }
}
