<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Cek apakah user sudah login
 */
if (!function_exists('check_login')) {
    function check_login() {
        $CI =& get_instance();
        if (!$CI->session->userdata('logged_in')) {
            redirect('login_siswa'); // default redirect ke login siswa
        }
    }
}

/**
 * Cek apakah user punya role yang sesuai
 * @param array $allowed_roles = [1,2,3]
 */
if (!function_exists('check_role')) {
    function check_role($allowed_roles = []) {
        $CI =& get_instance();
        $role_id = $CI->session->userdata('role_id');

        if (!in_array($role_id, $allowed_roles)) {
            // kalau role tidak sesuai → tendang ke logout
            redirect('auth/logout');
        }
    }
}
