<?php
defined('BASEPATH') OR exit('No direct script access allowed');

if (!function_exists('rupiah')) {
  function rupiah($n) {
    return 'Rp '.number_format((float)$n, 0, ',', '.');
  }
}

if (!function_exists('terbilang_id')) {
  function terbilang_id($x) {
    $abil = ["", "satu", "dua", "tiga", "empat", "lima", "enam", "tujuh", "delapan", "sembilan", "sepuluh", "sebelas"];
    $x = (int)$x;
    if ($x < 12) return $abil[$x];
    if ($x < 20) return terbilang_id($x-10)." belas";
    if ($x < 100) return terbilang_id(intval($x/10))." puluh".($x%10? " ".terbilang_id($x%10) : "");
    if ($x < 200) return "seratus".($x-100? " ".terbilang_id($x-100) : "");
    if ($x < 1000) return terbilang_id(intval($x/100))." ratus".($x%100? " ".terbilang_id($x%100) : "");
    if ($x < 2000) return "seribu".($x-1000? " ".terbilang_id($x-1000) : "");
    if ($x < 1000000) return terbilang_id(intval($x/1000))." ribu".($x%1000? " ".terbilang_id($x%1000) : "");
    if ($x < 1000000000) return terbilang_id(intval($x/1000000))." juta".($x%1000000? " ".terbilang_id($x%1000000) : "");
    return number_format($x,0,',','.');
  }
}

if (!function_exists('doc_number')) {
  // contoh: INV-HSI/2025/00123 atau Kwitansi/HSI/2025-0123
  function doc_number(string $prefix, int $seq): string {
    $y = date('Y');
    return ($prefix === 'INV')
      ? sprintf('INV-HSI/%s/%05d', $y, $seq)
      : sprintf('Kwitansi/HSI/%s-%04d', $y, $seq);
  }
}
