<?php defined('BASEPATH') OR exit('No direct script access allowed');

// NB: 'use' ini cuma alias namespace; tidak memicu autoload.
// Kita tetap akan require autoload.inc.php dulu sebelum new Dompdf.
use Dompdf\Dompdf;
use Dompdf\Options;

class Dompdf_lib
{
    /**
     * Cari file autoload Dompdf di beberapa kemungkinan lokasi.
     * Return: absolute path ke autoload.inc.php atau string kosong bila tidak ketemu.
     */
    private function find_autoload(): string
    {
        // Kemungkinan struktur:
        // 1) application/libraries/dompdf/autoload.inc.php
        // 2) application/libraries/dompdf/autoload.php            (beberapa paket lama)
        // 3) application/libraries/dompdf/dompdf/autoload.inc.php (zip dengan folder dompdf di dalam dompdf)
        // 4) application/third_party/dompdf/autoload.inc.php
        $candidates = [
            APPPATH . 'libraries/dompdf/autoload.inc.php',
            APPPATH . 'libraries/dompdf/autoload.php',
            APPPATH . 'libraries/dompdf/dompdf/autoload.inc.php',
            APPPATH . 'third_party/dompdf/autoload.inc.php',
        ];

        foreach ($candidates as $p) {
            if (is_file($p)) return $p;
        }
        return '';
    }

    /**
     * Buat instance Dompdf siap pakai.
     * - Autoload dompdf dulu (non-Composer)
     * - Set beberapa opsi yang aman di shared hosting/Windows
     */
    public function instance(): Dompdf
    {
        $autoload = $this->find_autoload();
        if ($autoload === '') {
            // Biarkan error ini kebaca jelas di log & layar
            $msg = 'Dompdf_lib: autoload dompdf TIDAK DITEMUKAN. Letakkan paket dompdf di '
                 . 'application/libraries/dompdf/ (harus ada file autoload.inc.php). '
                 . 'Alternatif: application/libraries/dompdf/dompdf/autoload.inc.php';
            log_message('error', $msg);
            show_error(nl2br(htmlspecialchars($msg)), 500, 'ERROR AUTOLOAD DOMPDF');
        }

        require_once $autoload;

        // Setelah require, pastikan classnya benar-benar ada:
        if (!class_exists('\Dompdf\Dompdf')) {
            $msg = 'Dompdf_lib: autoload ditemukan, namun class Dompdf\Dompdf tetap tidak tersedia. '
                 . 'Kemungkinan folder levelnya salah. Pastikan struktur berisi /src, /lib, /vendor & autoload.inc.php.';
            log_message('error', $msg);
            show_error(nl2br(htmlspecialchars($msg)), 500, 'ERROR AUTOLOAD DOMPDF');
        }

        // Setup opsi
        $opt = new Options();
        $opt->set('isHtml5ParserEnabled', true);
        $opt->set('isRemoteEnabled', true);          // boleh ambil gambar/logo absolute URL
        $tmp = FCPATH . 'uploads/pdf_tmp';           // folder temp tulis
        if (!is_dir($tmp)) @mkdir($tmp, 0777, true);
        $opt->set('tempDir', $tmp);
        $opt->set('fontDir', $tmp);
        $opt->set('chroot', FCPATH);                 // batasi akses file ke dalam webroot

        return new Dompdf($opt);
    }
}
