<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class DokumenSiswa_model extends CI_Model {

    /**
     * Ambil dokumen berdasarkan SiswaID (prioritas),
     * kalau NULL fallback ke UserID.
     */
    public function get_by_siswa($siswa_id = null, $user_id = null) {
        $this->db->select('d.*, j.NamaDokumen');
        $this->db->from('DokumenSiswa d');
        $this->db->join('JenisDokumen j', 'd.JenisDokumen = j.NamaDokumen', 'left');

        if ($siswa_id) {
            $this->db->where('d.SiswaID', $siswa_id);
        } elseif ($user_id) {
            $this->db->where('d.UserID', $user_id);
        }

        return $this->db->get()->result();
    }

    public function insert($data) {
        return $this->db->insert('DokumenSiswa', $data);
    }

    public function delete($id) {
        return $this->db->delete('DokumenSiswa', ['DokumenID' => $id]);
    }

    /**
     * Update dokumen setelah siswa diterima (isi SiswaID)
     */
    public function assign_siswa_id($user_id, $siswa_id) {
        return $this->db->where('UserID', $user_id)
                        ->update('DokumenSiswa', ['SiswaID' => $siswa_id]);
    }
}
