<?php $this->load->view('templates/auth_header'); ?>

<div class="auth-form-light text-left p-5">

  <!-- Logo -->
  <div class="brand-logo text-center mb-4">
    <img src="<?= base_url('assets/sb-admin2/img/hsilogo.png'); ?>" alt="HSI Logo" style="width:120px;">
  </div>

  <!-- Judul -->
  <h3 class="text-center mb-3">HSI Academy Jepang</h3>
  <h6 class="font-weight-light text-center">Silakan login untuk melanjutkan</h6>

  <!-- Flash Messages -->
  <?php if ($this->session->flashdata('error')): ?>
    <div class="alert alert-danger mt-3">
      <?= $this->session->flashdata('error'); ?>
    </div>
  <?php endif; ?>

  <?php if ($this->session->flashdata('success')): ?>
    <div class="alert alert-success mt-3">
      <?= $this->session->flashdata('success'); ?>
    </div>
  <?php endif; ?>

  <!-- Form Login -->
  <form class="pt-3" method="post" action="<?= base_url('login'); ?>">
    <div class="form-group">
      <input type="text" name="identity" class="form-control form-control-lg" placeholder="Email atau No HP" required>
    </div>
    <div class="form-group">
      <input type="password" name="password" class="form-control form-control-lg" placeholder="Password" required>
      <small class="form-text text-right">
        <a href="<?= base_url('auth/forgot_password'); ?>" class="text-primary">Lupa password?</a>
      </small>
    </div>

    <div class="form-group">
      <select name="role" class="form-control form-control-lg" required>
  <option value="">Login Sebagai</option>
  <option value="Admin">Admin</option>
  <!-- <option value="User">User</option> -->
  <option value="Siswa">Siswa</option>
</select>

    </div>

    <div class="mt-3">
      <button type="submit" class="btn btn-block btn-primary btn-lg font-weight-medium auth-form-btn">Login</button>
    </div>
    <div class="form-check">
  <label class="form-check-label">
    <input type="checkbox" name="remember" class="form-check-input"> Ingat saya
  </label>
</div>

    <div class="text-center mt-4 font-weight-light">
      Belum punya akun? <a href="<?= base_url('register'); ?>" class="text-primary">Register</a>
    </div>
  </form>
</div>

<?php $this->load->view('templates/auth_footer'); ?>
