<?php $this->load->view('templates/auth_header'); ?>

<div class="auth-form-light text-left p-5">
  <!-- Logo -->
  <div class="brand-logo text-center mb-4">
    <img src="<?= base_url('assets/sb-admin2/img/hsilogo.png'); ?>" alt="HSI Logo" style="width:120px;">
  </div>

  <!-- Judul -->
  <h3 class="text-center mb-3">Login Admin</h3>
  <h6 class="font-weight-light text-center mb-4">Silakan masuk sebagai administrator</h6>

  <!-- Flash Messages -->
  <?php if ($this->session->flashdata('error')): ?>
    <div class="alert alert-danger"><?= $this->session->flashdata('error'); ?></div>
  <?php endif; ?>
  <?php if ($this->session->flashdata('success')): ?>
    <div class="alert alert-success"><?= $this->session->flashdata('success'); ?></div>
  <?php endif; ?>

  <!-- Form -->
  <form method="post" action="<?= base_url('login_admin'); ?>">
    <div class="form-group">
      <input type="text" 
             name="identity" 
             class="form-control form-control-lg" 
             placeholder="Email"
             value="<?= isset($remember_identity) ? $remember_identity : set_value('identity'); ?>"
             required>
    </div>

    <div class="form-group">
      <input type="password" 
             name="password" 
             class="form-control form-control-lg" 
             placeholder="Password" 
             required>
    </div>

    <div class="form-check mb-3">
      <input type="checkbox" 
             class="form-check-input" 
             id="remember" 
             name="remember"
             <?= !empty($remember_identity) ? 'checked' : ''; ?>>
      <label class="form-check-label" for="remember">Ingat saya</label>
    </div>

    <button type="submit" class="btn btn-block btn-danger btn-lg">Login</button>

    <div class="text-center mt-4 font-weight-light">
      <a href="<?= base_url('login_siswa'); ?>" class="text-primary">Login Siswa</a>
    </div>
  </form>
</div>

<?php $this->load->view('templates/auth_footer'); ?>
