<?php $this->load->view('templates/auth_header'); ?>

<div class="container">
  <div class="card o-hidden border-0 shadow-lg my-5">
    <div class="card-body p-5">

      <!-- Logo & Judul -->
      <div class="text-center mb-4">
        <img src="<?= base_url('assets/sb-admin2/img/hsilogo.png'); ?>" alt="HSI Logo" style="width:120px;">
        <h1 class="h4 text-gray-900 mt-3">Registrasi Siswa HSI</h1>
        <p class="mb-0 text-muted" style="font-size: 0.9rem;">
          Program pelatihan HSI &mdash; status awal: <strong>Calon Siswa</strong>.
        </p>
      </div>

      <!-- Flash Messages -->
      <?php if ($this->session->flashdata('error')): ?>
        <div class="alert alert-danger"><?= $this->session->flashdata('error'); ?></div>
      <?php endif; ?>
      <?php if ($this->session->flashdata('success')): ?>
        <div class="alert alert-success"><?= $this->session->flashdata('success'); ?></div>
      <?php endif; ?>

      <!-- Form -->
      <form class="user" method="post" action="<?= base_url('auth/register_hsi'); ?>" enctype="multipart/form-data">

        <!-- ==================== DATA AKUN ==================== -->
        <h5 class="text-primary mb-3">Data Akun</h5>
        <div class="form-group row">
          <div class="col-md-6 mb-3">
            <input type="email"
                   name="email"
                   class="form-control form-control-user"
                   placeholder="Email"
                   value="<?= set_value('email'); ?>"
                   required>
            <?= form_error('email', '<small class="text-danger">', '</small>'); ?>
          </div>
          <div class="col-md-6">
            <input type="text"
                   name="phone"
                   class="form-control form-control-user"
                   placeholder="No HP"
                   value="<?= set_value('phone'); ?>"
                   required>
            <?= form_error('phone', '<small class="text-danger">', '</small>'); ?>
          </div>
        </div>

        <div class="form-group">
          <input type="password"
                 name="password"
                 class="form-control form-control-user"
                 placeholder="Password minimal 6 karakter"
                 required>
          <?= form_error('password', '<small class="text-danger">', '</small>'); ?>
        </div>

        <!-- ==================== DATA IDENTITAS ==================== -->
        <h5 class="text-primary mt-4 mb-3">Data Identitas</h5>

        <div class="form-group">
          <input type="text"
                 name="nama_lengkap"
                 class="form-control form-control-user"
                 placeholder="Nama Lengkap"
                 value="<?= set_value('nama_lengkap'); ?>"
                 required>
          <?= form_error('nama_lengkap', '<small class="text-danger">', '</small>'); ?>
        </div>

        <!-- Tanggal Lahir -->
        <div class="form-group">
          <label for="tanggal_lahir">Tanggal Lahir</label>
          <input type="date"
                 id="tanggal_lahir"
                 name="tanggal_lahir"
                 class="form-control"
                 value="<?= set_value('tanggal_lahir'); ?>"
                 required>
        </div>

        <!-- Usia -->
        <div class="form-group">
          <label for="usia">Usia</label>
          <div class="input-group">
            <input type="number"
                   id="usia"
                   name="usia"
                   class="form-control"
                   placeholder="15 - 35"
                   min="15"
                   max="35"
                   value="<?= set_value('usia'); ?>"
                   required>
            <div class="input-group-append">
              <span class="input-group-text">tahun</span>
            </div>
          </div>
        </div>

        <!-- Tinggi & Berat Badan -->
        <div class="form-row">
          <div class="form-group col-md-6">
            <label for="tinggi_badan">Tinggi Badan</label>
            <div class="input-group">
              <input type="number"
                     id="tinggi_badan"
                     name="tinggi_badan"
                     class="form-control"
                     placeholder="140 - 220"
                     min="140"
                     max="220"
                     value="<?= set_value('tinggi_badan'); ?>"
                     required>
              <div class="input-group-append">
                <span class="input-group-text">cm</span>
              </div>
            </div>
          </div>
          <div class="form-group col-md-6">
            <label for="berat_badan">Berat Badan</label>
            <div class="input-group">
              <input type="number"
                     id="berat_badan"
                     name="berat_badan"
                     class="form-control"
                     placeholder="40 - 120"
                     min="40"
                     max="120"
                     value="<?= set_value('berat_badan'); ?>"
                     required>
              <div class="input-group-append">
                <span class="input-group-text">kg</span>
              </div>
            </div>
          </div>
        </div>

        <!-- Jenis Kelamin -->
        <div class="form-group">
          <label class="d-block">Jenis Kelamin</label>
          <div class="form-check form-check-inline">
            <input class="form-check-input"
                   type="radio"
                   name="jenis_kelamin"
                   id="jk_pria"
                   value="Pria"
                   <?= set_radio('jenis_kelamin', 'Pria'); ?>
                   required>
            <label class="form-check-label" for="jk_pria">Pria</label>
          </div>
          <div class="form-check form-check-inline">
            <input class="form-check-input"
                   type="radio"
                   name="jenis_kelamin"
                   id="jk_perempuan"
                   value="Perempuan"
                   <?= set_radio('jenis_kelamin', 'Perempuan'); ?>
                   required>
            <label class="form-check-label" for="jk_perempuan">Perempuan</label>
          </div>
        </div>

        <div class="form-group">
          <input type="text"
                 name="domisili"
                 class="form-control form-control-user"
                 placeholder="Domisili"
                 value="<?= set_value('domisili'); ?>"
                 required>
        </div>

        <!-- Pendidikan -->
        <div class="form-group">
          <select name="pendidikan" class="form-control" required>
            <option value="">-- Pendidikan Terakhir --</option>
            <option value="SMA" <?= set_select('pendidikan','SMA'); ?>>SMA</option>
            <option value="SMK" <?= set_select('pendidikan','SMK'); ?>>SMK</option>
            <option value="MA"  <?= set_select('pendidikan','MA'); ?>>MA</option>
            <option value="D3"  <?= set_select('pendidikan','D3'); ?>>D3</option>
            <option value="S1"  <?= set_select('pendidikan','S1'); ?>>S1</option>
            <option value="S2"  <?= set_select('pendidikan','S2'); ?>>S2</option>
            <option value="S3"  <?= set_select('pendidikan','S3'); ?>>S3</option>
          </select>
        </div>

        <div class="form-group">
          <input type="text"
                 name="nama_sekolah"
                 class="form-control form-control-user"
                 placeholder="Nama Sekolah Terakhir"
                 value="<?= set_value('nama_sekolah'); ?>"
                 required>
        </div>

        <div class="form-group">
          <input type="text"
                 name="jurusan"
                 class="form-control form-control-user"
                 placeholder="Jurusan"
                 value="<?= set_value('jurusan'); ?>"
                 required>
        </div>

        <!-- Tato -->
        <div class="form-group">
          <select name="tato" class="form-control" required>
            <option value="">-- Memiliki Tato --</option>
            <option value="ADA"           <?= set_select('tato','ADA'); ?>>ADA</option>
            <option value="TIDAK ADA"     <?= set_select('tato','TIDAK ADA'); ?>>TIDAK ADA</option>
            <option value="SUDAH DIHAPUS" <?= set_select('tato','SUDAH DIHAPUS'); ?>>SUDAH DIHAPUS</option>
          </select>
        </div>

        <!-- Penglihatan -->
        <div class="form-group">
          <select name="penglihatan" class="form-control" required>
            <option value="">-- Kondisi Penglihatan --</option>
            <option value="NORMAL"       <?= set_select('penglihatan','NORMAL'); ?>>NORMAL</option>
            <option value="RABUN JAUH"   <?= set_select('penglihatan','RABUN JAUH'); ?>>RABUN JAUH</option>
            <option value="RABUN DEKAT"  <?= set_select('penglihatan','RABUN DEKAT'); ?>>RABUN DEKAT</option>
            <option value="SILINDER"     <?= set_select('penglihatan','SILINDER'); ?>>SILINDER</option>
            <option value="BUTA WARNA"   <?= set_select('penglihatan','BUTA WARNA'); ?>>BUTA WARNA</option>
          </select>
        </div>

        <!-- Info pendaftaran -->
        <div class="form-group">
          <select name="info_pendaftaran" class="form-control" required>
            <option value="">-- Info Pendaftaran Dari --</option>
            <option value="INSTAGRAM" <?= set_select('info_pendaftaran','INSTAGRAM'); ?>>INSTAGRAM</option>
            <option value="TIKTOK"    <?= set_select('info_pendaftaran','TIKTOK');    ?>>TIKTOK</option>
            <option value="FACEBOOK"  <?= set_select('info_pendaftaran','FACEBOOK');  ?>>FACEBOOK</option>
            <option value="TEMAN"     <?= set_select('info_pendaftaran','TEMAN');     ?>>TEMAN</option>
            <option value="SAUDARA"   <?= set_select('info_pendaftaran','SAUDARA');   ?>>SAUDARA</option>
          </select>
        </div>

        <div class="form-group">
          <input type="text"
                 name="rekomendasi_lpk"
                 class="form-control form-control-user"
                 placeholder="Rekomendasi LPK (jika ada)"
                 value="<?= set_value('rekomendasi_lpk'); ?>">
        </div>

        <!-- LPK: fix HSI -->
        <div class="form-group">
          <label>LPK</label>
          <input type="text"
                 class="form-control"
                 value="HSI"
                 readonly>
          <input type="hidden" name="lpk_id" value="<?= isset($default_lpk_id) ? $default_lpk_id : 1; ?>">
        </div>

        <!-- ==================== UPLOAD DOKUMEN ==================== -->
        <h5 class="text-primary mt-4 mb-3">Upload Dokumen</h5>
        <p class="text-muted" style="font-size:0.85rem;">
          Format file: <strong>JPG / JPEG / PNG / PDF</strong>, maksimal 2 MB per file.
        </p>

        <div class="form-group">
          <label>Pas Foto (wajib)</label>
          <input type="file" name="pas_foto" class="form-control" required
                 accept=".jpg,.jpeg,.png,.pdf">
        </div>

        <div class="form-group">
          <label>KTP (wajib)</label>
          <input type="file" name="ktp" class="form-control" required
                 accept=".jpg,.jpeg,.png,.pdf">
        </div>

        <div class="form-group">
          <label>KK (wajib)</label>
          <input type="file" name="kk" class="form-control" required
                 accept=".jpg,.jpeg,.png,.pdf">
        </div>

        <div class="form-group">
          <label>Akta Kelahiran (wajib)</label>
          <input type="file" name="akta" class="form-control" required
                 accept=".jpg,.jpeg,.png,.pdf">
        </div>

        <div class="form-group">
          <label>Paspor (opsional)</label>
          <input type="file" name="pasport" class="form-control"
                 accept=".jpg,.jpeg,.png,.pdf">
        </div>

        <div class="form-group">
          <label>Ijazah (opsional)</label>
          <input type="file" name="ijazah" class="form-control"
                 accept=".jpg,.jpeg,.png,.pdf">
        </div>

        <!-- Submit -->
        <button type="submit" class="btn btn-success btn-user btn-block">
          Daftar sebagai Siswa HSI
        </button>
      </form>

      <hr>
      <div class="text-center">
        Sudah punya akun?
        <a href="<?= base_url('login_siswa'); ?>" class="text-primary">Login</a>
      </div>

    </div>
  </div>
</div>

<script>
  (function() {
    // batas 2 MB
    var MAX_SIZE = 2 * 1024 * 1024;
    var inputs = [
      'pas_foto',
      'ktp',
      'kk',
      'akta',
      'pasport',
      'ijazah'
    ];

    inputs.forEach(function(name) {
      var el = document.querySelector('input[name="' + name + '"]');
      if (!el) return;

      el.addEventListener('change', function() {
        if (!el.files || !el.files.length) return;
        var file = el.files[0];
        if (file.size > MAX_SIZE) {
          alert('Ukuran file "' + file.name + '" lebih dari 2 MB. '
                + 'Silakan pilih file lain yang ukurannya kurang dari 2 MB.');
          el.value = ''; // reset input
        }
      });
    });
  })();
</script>

<?php $this->load->view('templates/auth_footer'); ?>
