<?php $this->load->view('templates/header'); ?>
<?php $this->load->view('templates/sidebar'); ?>
<?php $this->load->view('templates/topbar'); ?>

<div class="container mt-4">
    <h3><?= $title; ?></h3>

    <?php if ($this->session->flashdata('success')): ?>
        <div class="alert alert-success"><?= $this->session->flashdata('success'); ?></div>
    <?php elseif ($this->session->flashdata('error')): ?>
        <div class="alert alert-danger"><?= $this->session->flashdata('error'); ?></div>
    <?php endif; ?>

    <button class="btn btn-primary mb-3" data-toggle="modal" data-target="#modalAdd">
        <i class="fas fa-plus"></i> Tambah Biaya
    </button>

    <table class="table table-bordered table-hover">
        <thead class="thead-dark">
            <tr>
                <th>Jenis</th>
                <th>Negara</th>
                <th>Perusahaan</th>
                <th>Tahun</th>
                <th>Nominal</th>
                <th>Aksi</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($list as $r): ?>
                <tr>
                    <td><?= ucfirst($r->Jenis); ?></td>
                    <td><?= $r->Negara ?? '-'; ?></td>
                    <td><?= $r->Perusahaan ?? '-'; ?></td>
                    <td><?= $r->Tahun; ?></td>
                    <td>Rp <?= number_format($r->Nominal,0,',','.'); ?></td>
                    <td>
                        <!-- Edit -->
                        <a href="#" class="btn btn-sm btn-warning" data-toggle="modal"
                           data-target="#modalEdit<?= $r->BiayaID; ?>">Edit</a>
                        <!-- Delete -->
                        <a href="<?= base_url('biaya/delete/'.$r->BiayaID); ?>" 
                           class="btn btn-sm btn-danger" 
                           onclick="return confirm('Yakin hapus?')">Hapus</a>
                    </td>
                </tr>

                <!-- Modal Edit -->
                <div class="modal fade" id="modalEdit<?= $r->BiayaID; ?>" tabindex="-1">
                  <div class="modal-dialog">
                    <div class="modal-content">
                      <?= form_open('biaya/edit/'.$r->BiayaID); ?>
                      <div class="modal-header">
                        <h5 class="modal-title">Edit Biaya</h5>
                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                      </div>
                      <div class="modal-body">
                          <div class="form-group">
                              <label>Jenis</label>
                              <select name="Jenis" class="form-control" required>
                                  <option value="pelatihan" <?= $r->Jenis=='pelatihan'?'selected':'' ?>>Pelatihan</option>
                                  <option value="raftel" <?= $r->Jenis=='raftel'?'selected':'' ?>>Raftel</option>
                              </select>
                          </div>
                          <div class="form-group">
                              <label>Negara</label>
                              <input type="text" name="Negara" class="form-control" value="<?= $r->Negara; ?>">
                          </div>
                          <div class="form-group">
                              <label>Perusahaan</label>
                              <input type="text" name="Perusahaan" class="form-control" value="<?= $r->Perusahaan; ?>">
                          </div>
                          <div class="form-group">
                              <label>Tahun</label>
                              <input type="number" name="Tahun" class="form-control" value="<?= $r->Tahun; ?>" required>
                          </div>
                          <div class="form-group">
                              <label>Nominal</label>
                              <input type="number" name="Nominal" class="form-control" value="<?= $r->Nominal; ?>" required>
                          </div>
                      </div>
                      <div class="modal-footer">
                          <button type="submit" class="btn btn-primary">Simpan</button>
                          <button type="button" class="btn btn-secondary" data-dismiss="modal">Batal</button>
                      </div>
                      <?= form_close(); ?>
                    </div>
                  </div>
                </div>

            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<!-- Modal Tambah -->
<div class="modal fade" id="modalAdd" tabindex="-1">
  <div class="modal-dialog">
    <div class="modal-content">
      <?= form_open('biaya/add'); ?>
      <div class="modal-header">
        <h5 class="modal-title">Tambah Biaya</h5>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>
      <div class="modal-body">
          <div class="form-group">
              <label>Jenis</label>
              <select name="Jenis" class="form-control" required>
                  <option value="pelatihan">Pelatihan</option>
                  <option value="raftel">Raftel</option>
              </select>
          </div>
          <div class="form-group">
              <label>Negara</label>
              <input type="text" name="Negara" class="form-control">
          </div>
          <div class="form-group">
              <label>Perusahaan</label>
              <input type="text" name="Perusahaan" class="form-control">
          </div>
          <div class="form-group">
              <label>Tahun</label>
              <input type="number" name="Tahun" class="form-control" value="<?= date('Y'); ?>" required>
          </div>
          <div class="form-group">
              <label>Nominal</label>
              <input type="number" name="Nominal" class="form-control" required>
          </div>
      </div>
      <div class="modal-footer">
          <button type="submit" class="btn btn-primary">Simpan</button>
          <button type="button" class="btn btn-secondary" data-dismiss="modal">Batal</button>
      </div>
      <?= form_close(); ?>
    </div>
  </div>
</div>

<?php $this->load->view('templates/footer'); ?>
