<?php $this->load->view('templates/header'); ?>
<?php $this->load->view('templates/sidebar'); ?>
<?php $this->load->view('templates/topbar'); ?>

<div class="container-fluid">

  <div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0 text-gray-800"><?= html_escape($title ?? 'Dashboard'); ?></h1>
    <a href="<?= base_url('pembayaran_pelatihan/laporan'); ?>" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm">
      <i class="fas fa-download fa-sm text-white-50"></i> Laporan Pembayaran
    </a>
  </div>

  <!-- KPIs -->
  <div class="row">
    <!-- Total Siswa -->
    <div class="col-xl-3 col-md-6 mb-4">
      <div class="card border-left-primary shadow h-100 py-2">
        <div class="card-body d-flex align-items-center justify-content-between">
          <div>
            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">Total Siswa</div>
            <div class="h5 mb-0 font-weight-bold text-gray-800"><?= (int)($total_siswa ?? 0); ?></div>
          </div>
          <i class="fas fa-users fa-2x text-gray-300"></i>
        </div>
      </div>
    </div>

    <!-- Siswa Aktif -->
    <div class="col-xl-3 col-md-6 mb-4">
      <div class="card border-left-success shadow h-100 py-2">
        <div class="card-body d-flex align-items-center justify-content-between">
          <div>
            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">Siswa Aktif</div>
            <div class="h5 mb-0 font-weight-bold text-gray-800"><?= (int)($s_aktif ?? 0); ?></div>
          </div>
          <i class="fas fa-user-check fa-2x text-gray-300"></i>
        </div>
      </div>
    </div>

    <!-- Menunggu Pembayaran -->
    <div class="col-xl-3 col-md-6 mb-4">
      <div class="card border-left-warning shadow h-100 py-2">
        <div class="card-body d-flex align-items-center justify-content-between">
          <div>
            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">Menunggu Pembayaran</div>
            <div class="h5 mb-0 font-weight-bold text-gray-800"><?= (int)($s_menunggu ?? 0); ?></div>
          </div>
          <i class="fas fa-hourglass-half fa-2x text-gray-300"></i>
        </div>
      </div>
    </div>

    <!-- Total Approved -->
    <div class="col-xl-3 col-md-6 mb-4">
      <div class="card border-left-info shadow h-100 py-2">
        <div class="card-body d-flex align-items-center justify-content-between">
          <div>
            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">Total Approved</div>
            <div class="h5 mb-0 font-weight-bold text-gray-800">Rp <?= number_format((float)($total_approved ?? 0), 0, ',', '.'); ?></div>
            <div class="small text-muted"><?= (int)($pending_count ?? 0); ?> pending</div>
          </div>
          <i class="fas fa-cash-register fa-2x text-gray-300"></i>
        </div>
      </div>
    </div>
  </div>

  <!-- Charts -->
  <div class="row">
    <div class="col-xl-8 col-lg-7">
      <div class="card shadow mb-4">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
          <h6 class="m-0 font-weight-bold text-primary">Approved per Hari (30 hari)</h6>
        </div>
        <div class="card-body" style="min-height:320px">
          <!-- gunakan id yang sama dengan di JS -->
          <canvas id="chartDaily"></canvas>
          <?php if (empty($line_labels)): ?>
            <div class="text-center text-muted mt-3">Belum ada data approved dalam 30 hari terakhir.</div>
          <?php endif; ?>
        </div>
      </div>
    </div>

    <div class="col-xl-4 col-lg-5">
      <div class="card shadow mb-4">
        <div class="card-header py-3">
          <h6 class="m-0 font-weight-bold text-primary">Metode Pembayaran</h6>
        </div>
        <div class="card-body" style="min-height:320px">
          <canvas id="chartPie"></canvas>
          <?php if (empty($pie_labels)): ?>
            <div class="text-center text-muted mt-3">Belum ada komposisi metode (30 hari).</div>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </div>

  <!-- Recent table -->
  <div class="card shadow mb-4">
    <div class="card-header py-3">
      <h6 class="m-0 font-weight-bold text-primary">Transaksi Terbaru</h6>
    </div>
    <div class="card-body">
      <?php if (!empty($recent)): ?>
        <div class="table-responsive">
          <table class="table table-sm table-hover">
            <thead>
              <tr>
                <th>#</th><th>Tanggal</th><th>Nama</th><th>Metode</th><th>Status</th>
                <th class="text-right">Jumlah</th><th></th>
              </tr>
            </thead>
            <tbody>
              <?php foreach ($recent as $r): ?>
                <tr>
                  <td><?= (int)$r->PembayaranID; ?></td>
                  <td><?= $r->TanggalBayar ? date('Y-m-d H:i', strtotime($r->TanggalBayar)) : '-'; ?></td>
                  <td><?= html_escape($r->NamaLengkap ?: ($r->Email ?? '-')); ?></td>
                  <td><?= html_escape($r->MetodeBayar ?: '-'); ?></td>
                  <td>
                    <?php $st = strtolower((string)$r->StatusBayar); ?>
                    <span class="badge badge-<?= $st==='approved'?'success':($st==='pending'?'warning':'secondary'); ?>">
                      <?= $st ? ucfirst($st) : '-'; ?>
                    </span>
                  </td>
                  <td class="text-right">Rp <?= number_format((float)($r->JumlahBayar ?? 0), 0, ',', '.'); ?></td>
                  <td>
                    <a class="btn btn-sm btn-outline-primary"
                       href="<?= base_url('pembayaran_pelatihan/detail/'.($r->SiswaID ?: (int)$r->UserID)); ?>">
                       Ke Detail
                    </a>
                  </td>
                </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>
      <?php else: ?>
        <div class="text-center text-muted">Belum ada transaksi.</div>
      <?php endif; ?>
    </div>
  </div>

</div>

<?php $this->load->view('templates/footer'); ?>

<script>
  // data dari controller
  const lineLabels = <?= json_encode($line_labels ?? []); ?>;
  const lineData   = <?= json_encode($line_values ?? []); ?>;
  const pieLabels  = <?= json_encode($pie_labels ?? []); ?>;
  const pieData    = <?= json_encode($pie_values ?? []); ?>;

  // warna konsisten per-metode
  const colorMap = {
    'Transfer Bank': '#4e73df',
    'E-Wallet'     : '#1cc88a',
    'Tunai'        : '#f6c23e',
    '-'            : '#858796'
  };
  const pieColors = pieLabels.map(l => colorMap[l] || '#36b9cc');

  // LINE: pastikan id sama -> chartDaily
  if (document.getElementById('chartDaily')) {
    new Chart(document.getElementById('chartDaily'), {
      type: 'line',
      data: {
        labels: lineLabels,
        datasets: [{
          label: 'Approved',
          data: lineData,
          borderWidth: 2,
          tension: 0.3,
          pointRadius: 3,
          fill: false
        }]
      },
      options: {
        responsive: true,
        maintainAspectRatio: false,
        scales: {
          y: { ticks: { callback: v => 'Rp ' + (v || 0).toLocaleString('id-ID') } }
        }
      }
    });
  }

  // PIE
  if (document.getElementById('chartPie')) {
    new Chart(document.getElementById('chartPie'), {
      type: 'doughnut',
      data: { labels: pieLabels, datasets: [{ data: pieData, backgroundColor: pieColors }] },
      options: { responsive: true, maintainAspectRatio: false, plugins: { legend: { position: 'bottom' } } }
    });
  }
</script>
