<?php $this->load->view('templates/header'); ?>
<?php $this->load->view('templates/sidebar'); ?>
<?php $this->load->view('templates/topbar'); ?>

<div class="container-fluid">
  <h1 class="h3 mb-4 text-gray-800"><?= $title; ?></h1>

  <div class="card shadow mb-4">
    <div class="card-header py-3">
      <h6 class="m-0 font-weight-bold text-primary">Daftar Calon Siswa HSI</h6>
    </div>
    <div class="card-body">
      <div class="table-responsive">
        <table class="table table-bordered table-hover" width="100%" cellspacing="0">
          <thead class="thead-light">
            <tr>
              <th>User ID</th>
              <th>Siswa ID</th>
              <th>Nama Lengkap</th>
              <th>Email</th>
              <th>No HP</th>
              <th>Tanggal Daftar</th>
              <th>Status</th>
              <th>Aksi</th>
            </tr>
          </thead>
          <tbody>
            <?php if (!empty($calon_siswa)): ?>
              <?php foreach ($calon_siswa as $s): ?>
              <tr>
                <td><?= $s->UserID; ?></td>
                <td><?= $s->SiswaID ?? '<span class="text-muted">-</span>'; ?></td>
                <td><?= $s->NamaLengkap; ?></td>
                <td><?= $s->Email; ?></td>
                <td><?= $s->Phone; ?></td>
                <td><?= date('d-m-Y H:i', strtotime($s->CreatedAt)); ?></td>
                <td>
                  <?php if ($s->NamaStatus == 'Calon'): ?>
                    <span class="badge badge-warning"><?= $s->NamaStatus; ?></span>
                  <?php elseif ($s->NamaStatus == 'Aktif'): ?>
                    <span class="badge badge-success"><?= $s->NamaStatus; ?></span>
                  <?php elseif ($s->NamaStatus == 'Ditolak'): ?>
                    <span class="badge badge-danger"><?= $s->NamaStatus; ?></span>
                  <?php else: ?>
                    <span class="badge badge-secondary">Belum ditentukan</span>
                  <?php endif; ?>
                </td>
                <td>
                  <!-- Hanya tombol Detail -->
                  <a href="<?= base_url('siswa/detail_calon_hsi/'.$s->UserID); ?>" 
                     class="btn btn-sm btn-info">
                    <i class="fas fa-search"></i> Detail
                  </a>
                </td>
              </tr>
              <?php endforeach; ?>
            <?php else: ?>
              <tr>
                <td colspan="8" class="text-center text-muted">Belum ada calon siswa terdaftar</td>
              </tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>

<?php $this->load->view('templates/footer'); ?>
