<div class="container-fluid">
  <h1 class="h3 mb-4 text-gray-800"><?= $title ?></h1>

  <?php if($this->session->flashdata('error')): ?>
    <div class="alert alert-danger"><?= $this->session->flashdata('error'); ?></div>
  <?php endif; ?>
  <?php if($this->session->flashdata('success')): ?>
    <div class="alert alert-success"><?= $this->session->flashdata('success'); ?></div>
  <?php endif; ?>

  <!-- Form Upload Dokumen -->
  <div class="card shadow mb-4">
    <div class="card-header py-3">
      <h6 class="m-0 font-weight-bold text-primary">Upload Dokumen Baru</h6>
    </div>
    <div class="card-body">
      <?= form_open_multipart('dokumen/upload'); ?>
        <div class="form-group">
          <label>Jenis Dokumen</label>
          <select name="jenis_dokumen" class="form-control" required>
            <option value="">-- Pilih --</option>
            <option value="1">KTP</option>
            <option value="2">Ijazah</option>
            <option value="3">Bukti Pembayaran</option>
          </select>
        </div>
        <div class="form-group">
          <label>File Dokumen (jpg, png, pdf, max 2MB)</label>
          <input type="file" name="file_dokumen" class="form-control" required>
        </div>
        <button type="submit" class="btn btn-primary">Upload</button>
      <?= form_close(); ?>
    </div>
  </div>

  <!-- Tabel Dokumen -->
  <div class="card shadow mb-4">
    <div class="card-body">
      <div class="table-responsive">
        <table class="table table-bordered">
          <thead>
            <tr>
              <th>Jenis Dokumen</th>
              <th>File</th>
              <th>Upload At</th>
              <th>Aksi</th>
            </tr>
          </thead>
          <tbody>
            <?php if(!empty($dokumen)): ?>
              <?php foreach($dokumen as $row): ?>
                <tr>
                  <td><?= $row->NamaDokumen ?></td>
                  <td><a href="<?= base_url($row->FilePath) ?>" target="_blank">Lihat</a></td>
                  <td><?= $row->UploadedAt ?></td>
                  <td>
                    <a href="<?= base_url('dokumen/hapus/'.$row->DokumenID) ?>"
                       class="btn btn-danger btn-sm"
                       onclick="return confirm('Yakin hapus dokumen ini?')">Hapus</a>
                  </td>
                </tr>
              <?php endforeach; ?>
            <?php else: ?>
              <tr><td colspan="4" class="text-center">Belum ada dokumen.</td></tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
