<?php $this->load->view('templates/header'); ?>
<?php $this->load->view('templates/sidebar'); ?>
<?php $this->load->view('templates/topbar'); ?>

<div class="container-fluid">
  <h1 class="h3 mb-4 text-gray-800"><?= $title ?></h1>

  <div class="row">
    <!-- Kolom Detail -->
    <div class="col-md-8">
      <div class="card shadow mb-4">
        <div class="card-header d-flex justify-content-between align-items-center">
          <h6 class="m-0 font-weight-bold text-primary">Detail Calon Siswa</h6>
          <span class="badge badge-secondary p-2" style="font-size: 1rem;">Calon</span>
        </div>
        <div class="card-body">
          <table class="table table-borderless">
            <tr><th>User ID</th><td><?= $user->UserID ?></td></tr>
            <tr><th>Username</th><td><?= $user->Username ?></td></tr>
            <tr><th>Email</th><td><?= $user->Email ?></td></tr>
            <tr><th>No HP</th><td><?= $user->Phone ?></td></tr>
            <tr><th>Tanggal Daftar</th><td><?= $user->CreatedAt ?></td></tr>
          </table>
        </div>
      </div>
    </div>

    <!-- Kolom Foto -->
    <div class="col-md-4">
      <div class="card shadow mb-4">
        <div class="card-header">
          <h6 class="m-0 font-weight-bold text-primary">Foto Calon Siswa</h6>
        </div>
        <div class="card-body text-center">
          <?php 
$foto = null;
if (!empty($dokumen)) {
    foreach ($dokumen as $d) {
        if ($d->JenisDokumen == 'pas_foto') {
            $foto = $d->FilePath;
        }
    }
}
?>

<?php if($foto): ?>
    <img src="<?= base_url('uploads/siswa/'.$user->UserID.'/'.$foto) ?>" 
         alt="Foto Siswa" class="img-fluid rounded mb-2" style="max-height:300px;">
<?php else: ?>
    <img src="<?= base_url('assets/img/default-user.png') ?>" 
         alt="Default Foto" class="img-fluid rounded mb-2" style="max-height:300px;">
    <p class="text-muted">Belum ada foto</p>
<?php endif; ?>

        </div>
      </div>
    </div>
  </div>

  <!-- Dokumen -->
  <div class="card shadow mb-4">
    <div class="card-header py-3">
      <h6 class="m-0 font-weight-bold text-primary">Dokumen Calon Siswa</h6>
    </div>
    <div class="card-body">
      <table class="table table-bordered">
        <thead>
          <tr><th>Jenis Dokumen</th><th>File</th></tr>
        </thead>
        <tbody>
          <?php 
            $jenis = ['pas_foto'=>'Pas Foto','ktp'=>'KTP','kk'=>'Kartu Keluarga','akta'=>'Akta','pasport'=>'Paspor','ijazah'=>'Ijazah'];
            foreach ($jenis as $key=>$label): 
              $file = null;
              if (!empty($dokumen)) {
                foreach ($dokumen as $d) {
                  if ($d->JenisDokumen == $key) {
                    $file = $d->FilePath;
                  }
                }
              }
          ?>
          <tr>
            <td><?= $label ?></td>
            <td>
              <?php if($file): ?>
                <a href="<?= base_url('uploads/siswa/'.$user->UserID.'/'.$file) ?>" 
                   target="_blank" class="btn btn-sm btn-info">Lihat</a>
              <?php else: ?>
                <span class="text-muted">Belum diupload</span>
              <?php endif; ?>
            </td>
          </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>

</div>

<?php $this->load->view('templates/footer'); ?>
