<?php $this->load->view('templates/header'); ?>
<?php $this->load->view('templates/sidebar'); ?>
<?php $this->load->view('templates/topbar'); ?>

<div class="container-fluid">
  <h1 class="h3 mb-4 text-gray-800"><?= html_escape($title ?? 'Ubah Status Siswa') ?></h1>

  <?php if($this->session->flashdata('success')): ?>
    <div class="alert alert-success"><?= $this->session->flashdata('success'); ?></div>
  <?php endif; ?>
  <?php if($this->session->flashdata('error')): ?>
    <div class="alert alert-danger"><?= $this->session->flashdata('error'); ?></div>
  <?php endif; ?>

  <?php if (empty($siswa)): ?>
    <div class="alert alert-warning">Data siswa tidak ditemukan.</div>
    <a href="<?= base_url('siswa') ?>" class="btn btn-secondary">Kembali</a>
  <?php else: ?>
    <div class="card shadow mb-4">
      <div class="card-body">
        <?= form_open('siswa/ubahstatus/' . rawurlencode($siswa->SiswaID)); ?>
          <div class="form-group">
            <label class="form-label">Siswa</label>
            <div class="form-control-plaintext">
              <b><?= html_escape($siswa->NamaLengkap ?? '-') ?></b>
              <span class="text-muted"> (<?= html_escape($siswa->SiswaID ?? '-') ?>)</span>
            </div>
          </div>

          <div class="form-group">
            <label for="status_id">Status</label>
            <select name="status_id" id="status_id" class="form-control" required>
              <?php foreach ((array)$status_list as $st): ?>
                <option value="<?= (int)$st->StatusID ?>"
                  <?= ((int)($siswa->StatusID ?? 0) === (int)$st->StatusID) ? 'selected' : '' ?>>
                  <?= html_escape($st->NamaStatus) ?>
                </option>
              <?php endforeach; ?>
            </select>
          </div>

          <button type="submit" class="btn btn-primary">Simpan</button>
          <a href="<?= base_url('dashboard/kelola') ?>" class="btn btn-secondary">Batal</a>
        <?= form_close(); ?>
      </div>
    </div>
  <?php endif; ?>
</div>

<?php $this->load->view('templates/footer'); ?>
