<!doctype html>
<html>
<head>
<meta charset="utf-8">
<title>Kwitansi Pembayaran</title>
<style>
  body{ font-family: DejaVu Sans, Arial, sans-serif; font-size:12px; color:#222; }
  .wrap{ padding:22px 26px; }
  h2{ margin:0 0 6px; font-size:18px; }
  .muted{ color:#666; font-size:11px; margin-bottom:14px; }
  table.meta{ width:100%; border-collapse:collapse; margin:10px 0 16px; }
  table.meta td{ padding:6px 8px; }
  .row{ display:flex; gap:16px; }
  .col{ flex:1; border:1px solid #ddd; border-radius:6px; padding:10px; }
  .label{ color:#666; font-size:11px; }
  .big{ font-size:14px; font-weight:700; }
  .amount{ font-size:16px; font-weight:700; text-align:right; }
  .note{ margin-top:12px; font-size:11px; }
  .footer{ margin-top:26px; text-align:right; }
</style>
</head>
<body>
<div class="wrap">
  <h2>KWITANSI PEMBAYARAN</h2>
  <div class="muted">No: <?= htmlspecialchars($no_kwitansi) ?> · Tanggal: <?= htmlspecialchars($tanggal) ?></div>

  <div class="row">
    <div class="col">
      <div class="label">Telah diterima dari</div>
      <div class="big"><?= htmlspecialchars($nama) ?></div>
      <div>Asal LPK: <?= htmlspecialchars($lpk) ?></div>
      <div>Keperluan: <b><?= htmlspecialchars($keperluan) ?></b></div>
      <div>Metode: <?= htmlspecialchars($metode) ?></div>
    </div>
    <div class="col">
      <div class="label">Jumlah</div>
      <div class="amount"><?= rupiah($jumlah) ?></div>
      <div class="label" style="margin-top:10px">Terbilang:</div>
      <div><i><?= terbilang_id((int)$jumlah) ?> rupiah</i></div>
    </div>
  </div>

  <div class="footer">
    Hormat kami,<br><b>HSI Academy</b>
  </div>
</div>
</body>
</html>
