<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <title><?= html_escape($title); ?></title>
  <style>
    body { font-family: DejaVu Sans, Arial, sans-serif; font-size: 12px; }
    table { border-collapse: collapse; width: 100%; }
    th, td { border: 1px solid #000; padding: 4px; }
    th { background: #eee; }
    .text-right { text-align: right; }
  </style>
</head>
<body>
  <h3 style="text-align:center;"><?= html_escape($title); ?></h3>
  <p>
    Periode: <?= html_escape($filters['date_from']); ?> s/d <?= html_escape($filters['date_to']); ?><br>
    Dicetak: <?= date('d-m-Y H:i'); ?>
  </p>

  <table>
    <thead>
      <tr>
        <th>#</th>
        <th>Tanggal</th>
        <th>Nama Siswa</th>
        <th>Keterangan</th>
        <th>Metode</th>
        <th>Status</th>
        <th class="text-right">Jumlah (Rp)</th>
      </tr>
    </thead>
    <tbody>
      <?php 
      $no = 1; 
      $subtotal = 0;
      foreach ($pembayaran as $row): 
          $subtotal += (float) $row['jumlah_bayar'];
      ?>
        <tr>
          <td><?= $no++; ?></td>
          <td><?= html_escape($row['tanggal_bayar']); ?></td>
          <td><?= html_escape($row['nama_siswa']); ?></td>
          <td><?= html_escape($row['keterangan']); ?></td>
          <td><?= html_escape(ucfirst($row['metode_bayar'])); ?></td>
          <td><?= strtoupper($row['status']); ?></td>
          <td class="text-right"><?= number_format($row['jumlah_bayar'], 0, ',', '.'); ?></td>
        </tr>
      <?php endforeach; ?>
      <tr>
        <td colspan="6" class="text-right"><strong>TOTAL</strong></td>
        <td class="text-right"><strong>Rp <?= number_format($subtotal, 0, ',', '.'); ?></strong></td>
      </tr>
    </tbody>
  </table>
</body>
</html>
