<?php
// Expect: $no_kwitansi, $tanggal, $nama, $lpk, $keperluan, $metode, $jumlah
// Optional: $termin_ke, $siswaid, $logo_left, $logo_right, $stempel_url, $ttd_url

if (!function_exists('rupiah')) {
  function rupiah($n){ return 'Rp '.number_format((float)$n,0,',','.'); }
}
$termin_ke = isset($termin_ke) ? (int)$termin_ke : null;

// amanin terbilang
$terbilang = '';
if (function_exists('terbilang_id')) {
  $terbilang = strtoupper(terbilang_id((int)round($jumlah))).' RUPIAH';
}

if (empty($stempel_url) && function_exists('base_url')) {
  $stempel_url = base_url('assets/sb-admin2/img/stamp_HSI.png');
}
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <title>Kwitansi Pembayaran</title>
  <style>
    @page { size: A4; margin: 14mm 14mm 14mm 14mm; }
    body{ font-family: DejaVu Sans, Arial, Helvetica, sans-serif; font-size:12px; color:#222; }
    .row{ display:flex; justify-content:space-between; align-items:flex-start; }
    .left{ width:58%; } .right{ width:40%; text-align:right; }
    .title{ font-size:22px; font-weight:800; letter-spacing:1px; margin:0; }
    .badge{ display:inline-block; background:#111; color:#fff; padding:3px 8px; border-radius:12px; font-size:10px; margin-left:6px; }
    .muted{ color:#666; }
    .box{ border:1px solid #ddd; border-radius:8px; padding:10px 12px; }
    table{ border-collapse:collapse; width:100%; }
    .meta td{ padding:4px 6px; vertical-align:top; }
    .amount{ font-size:18px; font-weight:800; padding:8px 12px; background:#111; color:#fff; border-radius:6px; display:inline-block; }
    .stamp{ height:90px; opacity:.95; }
    .ttd{ height:60px; }
    .bar{ height:6px; background:#e53935; border-radius:3px; }
  </style>
</head>
<body>

  <div class="row" style="margin-bottom:8px;">
    <div><?php if(!empty($logo_left)): ?><img src="<?= $logo_left ?>" style="height:54px"><?php endif; ?></div>
    <div style="text-align:center">
      <h1 class="title">KWITANSI PEMBAYARAN<?= $termin_ke ? ' <span class="badge">Termin #'.(int)$termin_ke.'</span>' : '' ?></h1>
      <div class="muted">Japanese Language Training Center</div>
    </div>
    <div class="right"><?php if(!empty($logo_right)): ?><img src="<?= $logo_right ?>" style="height:54px"><?php endif; ?></div>
  </div>
  <div class="bar"></div>

  <table class="meta" style="margin-top:10px;">
    <tr>
      <td style="width:55%">
        <div class="box">
          <table class="meta">
            <tr><td style="width:110px;">No. Kwitansi</td><td>: <b><?= html_escape($no_kwitansi) ?></b></td></tr>
            <tr><td>Tanggal</td><td>: <?= html_escape($tanggal) ?></td></tr>
            <?php if(!empty($siswaid)): ?><tr><td>SiswaID</td><td>: <?= html_escape($siswaid) ?></td></tr><?php endif; ?>
          </table>
        </div>
      </td>
      <td>
        <div class="box">
          <table class="meta">
            <tr><td style="width:100px;">Nama</td><td>: <?= html_escape($nama) ?></td></tr>
            <tr><td>Asal LPK</td><td>: <?= html_escape($lpk ?: '-') ?></td></tr>
            <tr><td>Metode</td><td>: <?= html_escape($metode ?: '-') ?></td></tr>
          </table>
        </div>
      </td>
    </tr>
  </table>

  <div class="box" style="margin-top:12px;">
    <table class="meta">
      <tr><td style="width:110px;">Keperluan</td><td>: <?= html_escape($keperluan ?: 'Biaya Pelatihan') ?></td></tr>
      <?php if($termin_ke): ?><tr><td>Termin</td><td>: Termin <?= (int)$termin_ke ?></td></tr><?php endif; ?>
    </table>
    <div style="margin-top:10px;">
      <div class="muted">Jumlah dibayar</div>
      <div class="amount"><?= rupiah($jumlah) ?></div>
      <?php if($terbilang): ?>
        <div class="muted" style="margin-top:6px;"><i>(<?= $terbilang ?>)</i></div>
      <?php endif; ?>
    </div>
  </div>

  <div class="row" style="margin-top:22px; align-items:flex-end;">
    <div class="left">
      <div class="muted">
        Kwitansi ini diterbitkan otomatis oleh sistem HSI. Simpan bukti pembayaran ini.
        Pembayaran yang tidak melalui rekening <b>YAYASAN HIROSHI SEIYA INDONESIA</b>
        dianggap <b>belum lunas</b>.
      </div>
    </div>
    <div class="right">
      <?php if(!empty($stempel_url)): ?><img src="<?= $stempel_url ?>" class="stamp" alt="stempel"><br><?php endif; ?>
      <?php if(!empty($ttd_url)): ?><img src="<?= $ttd_url ?>" class="ttd" alt="ttd"><br><?php endif; ?>
      <div style="margin-top:6px;">Pimpinan LPK Hiroshi Seiya</div>
    </div>
  </div>

</body>
</html>
