<?php $this->load->view('templates/header'); ?>
<?php $this->load->view('templates/sidebar'); ?>
<?php $this->load->view('templates/topbar'); ?>

<div class="container-fluid">
  <h1 class="h3 mb-4 text-gray-800"><?= $title; ?></h1>

  <div class="card shadow mb-4">
    <div class="card-header py-3">
      <h6 class="m-0 font-weight-bold text-primary">Daftar Pembayaran Raftel</h6>
    </div>
    <div class="card-body">
      <div class="table-responsive">
        <table class="table table-bordered table-hover">
          <thead class="thead-light">
            <tr>
              <th>Nama Lengkap</th>
              <th>LPK</th>
              <th>Status</th>
              <th>Total Biaya</th>
              <th>Total Bayar</th>
              <th>Sisa Tagihan</th>
              <th>Aksi</th>
            </tr>
          </thead>
          <tbody>
            <?php if (!empty($siswa)): ?>
              <?php foreach ($siswa as $s): ?>
                <tr>
                  <td><?= $s['NamaLengkap']; ?></td>
                  <td><?= $s['LPK']; ?></td>
                  <td>
                    <?php if ($s['Status'] == 'Siap Berangkat'): ?>
                      <span class="badge badge-success"><?= $s['Status']; ?></span>
                    <?php elseif ($s['Status'] == 'Calon'): ?>
                      <span class="badge badge-warning"><?= $s['Status']; ?></span>
                    <?php else: ?>
                      <span class="badge badge-secondary"><?= $s['Status']; ?></span>
                    <?php endif; ?>
                  </td>
                  <td>Rp <?= number_format($s['TotalBiaya'], 0, ',', '.'); ?></td>
                  <td>Rp <?= number_format($s['TotalBayar'], 0, ',', '.'); ?></td>
                  <td>Rp <?= number_format($s['SisaTagihan'], 0, ',', '.'); ?></td>
                  <td>
                    <!-- DETAIL -->
                    <a href="<?= base_url('pembayaran_raftel/detail/' . (!empty($s['SiswaID']) ? $s['SiswaID'] : $s['UserID'])); ?>" 
   class="btn btn-sm btn-info">
   <i class="fas fa-info-circle"></i> Detail
</a>

                    <!-- REJECT SISWA -->
                    <a href="<?= base_url('pembayaran_raftel/reject_siswa/' . $s['UserID']); ?>" 
                       class="btn btn-sm btn-danger"
                       onclick="return confirm('Yakin ingin menolak siswa ini?');">
                       <i class="fas fa-times"></i> Reject
                    </a>
                  </td>
                </tr>
              <?php endforeach; ?>
            <?php else: ?>
              <tr>
                <td colspan="7" class="text-center text-muted">
                  Belum ada data pembayaran raftel.
                </td>
              </tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>

<?php $this->load->view('templates/footer'); ?>
