<?php $this->load->view('templates/header'); ?>
<?php $this->load->view('templates/sidebar'); ?>
<?php $this->load->view('templates/topbar'); ?>

<div class="container mt-4">

  <!-- Title -->
  <h4 class="mb-3"><?= isset($title) ? htmlspecialchars($title) : 'Pembayaran Pelatihan'; ?></h4>

  <!-- Flash -->
  <?php if ($this->session->flashdata('success')): ?>
    <div class="alert alert-success"><?= $this->session->flashdata('success'); ?></div>
  <?php endif; ?>
  <?php if ($this->session->flashdata('error')): ?>
    <div class="alert alert-danger"><?= $this->session->flashdata('error'); ?></div>
  <?php endif; ?>

  <!-- Ringkasan -->
  <div class="row">
    <div class="col-md-4">
      <div class="card shadow-sm mb-3">
        <div class="card-body">
          <div class="d-flex justify-content-between">
            <span>Total Biaya</span>
            <strong>Rp <?= number_format((float)($total_biaya ?? 0),0,',','.'); ?></strong>
          </div>
          <div class="d-flex justify-content-between mt-2">
            <span>Total Bayar (Approved)</span>
            <strong>Rp <?= number_format((float)($total_bayar ?? 0),0,',','.'); ?></strong>
          </div>
          <hr class="my-2">
          <div class="d-flex justify-content-between">
            <span>Sisa Tagihan</span>
            <strong class="<?= (($sisa_tagihan ?? 0) > 0)?'text-danger':'text-success'; ?>">
              Rp <?= number_format((float)($sisa_tagihan ?? 0),0,',','.'); ?>
            </strong>
          </div>
        </div>
      </div>
    </div>

    <!-- Form Upload -->
    <div class="col-md-8">
      <div class="card shadow-sm mb-3">
        <div class="card-header">Kirim Pembayaran</div>
        <div class="card-body">
          <form action="<?= site_url('pembayaran_pelatihan/submit'); ?>" method="post" enctype="multipart/form-data">
            <div class="row">
              <div class="col-md-5 mb-3">
                <label class="form-label">Jumlah Bayar</label>
                <input type="number" name="JumlahBayar" class="form-control" min="1" step="1" required>
                <small class="text-muted">Masukkan angka tanpa titik/koma.</small>
              </div>
              <div class="col-md-4 mb-3">
                <label class="form-label">Metode Bayar</label>
                <select name="MetodeBayar" class="form-control" required>
                  <option value="" disabled selected>Pilih</option>
                  <option value="Transfer Bank">Transfer Bank</option>
                  <option value="E-Wallet">E-Wallet</option>
                  <option value="Tunai">Tunai</option>
                </select>
              </div>
              <div class="col-md-12 mb-3">
                <label class="form-label d-block">Bukti Transfer (jpg, jpeg, png, pdf; maks 4MB)</label>
                <input type="file" name="BuktiTransfer" class="form-control" accept=".jpg,.jpeg,.png,.pdf">
              </div>
            </div>

            <button class="btn btn-primary">
              <i class="bi bi-upload"></i> Kirim Pembayaran
            </button>
          </form>
        </div>
      </div>
    </div>
  </div>

  <!-- Riwayat Transaksi (dari tabel Pembayaran) -->
  <div class="card shadow-sm mb-4">
    <div class="card-header">Riwayat Transaksi</div>
    <div class="card-body table-responsive">
      <table class="table table-sm table-striped align-middle">
        <thead>
          <tr>
            <th style="width:140px">Tanggal</th>
            <th style="width:140px">Jumlah</th>
            <th style="width:140px">Metode</th>
            <th>Bukti Transfer</th>
            <th style="width:140px">Status</th>
          </tr>
        </thead>
        <tbody>
        <?php if (!empty($riwayat)): ?>
          <?php foreach($riwayat as $r): ?>
            <tr>
              <td><?= !empty($r->TanggalBayar) ? date('Y-m-d H:i', strtotime($r->TanggalBayar)) : '-'; ?></td>
              <td>Rp <?= number_format((float)($r->JumlahBayar ?? 0),0,',','.'); ?></td>
              <td><?= htmlspecialchars($r->MetodeBayar ?? '-'); ?></td>
              <td>
                <?php if (!empty($r->BuktiTransfer)): ?>
                  <a href="<?= base_url('uploads/bukti_transfer/'.$r->BuktiTransfer); ?>" target="_blank">Lihat</a>
                <?php else: ?>
                  -
                <?php endif; ?>
              </td>
              <td>
                <?php
                  $status = $r->StatusBayar ?? '-';
                  $badge  = ($status==='Approved')?'success':(($status==='Rejected')?'danger':'secondary');
                ?>
                <span class="badge bg-<?= $badge; ?>"><?= htmlspecialchars($status); ?></span>
              </td>
            </tr>
          <?php endforeach; ?>
        <?php else: ?>
          <tr><td colspan="5" class="text-center text-muted">Belum ada transaksi.</td></tr>
        <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>

  <!-- Ledger (tabel PembayaranSiswa), hanya tampilan -->
  <div class="card shadow-sm mb-5">
    <div class="card-header">Ledger (Approved saja)</div>
    <div class="card-body table-responsive">
      <table class="table table-sm table-bordered align-middle">
        <thead>
          <tr>
            <th style="width:140px">Tanggal</th>
            <th style="width:180px">Jenis</th>
            <th style="width:140px">Nominal</th>
            <th>Bukti</th>
          </tr>
        </thead>
        <tbody>
        <?php
          // Controller bisa mengirim $ledger dari PembayaranSiswa_model::get_ledger_by_siswa()
          // Backward compatible kalau variabelnya bernama $history
          $ledgerRows = isset($ledger) ? $ledger : (isset($history) ? $history : []);
        ?>
        <?php if (!empty($ledgerRows)): ?>
          <?php foreach($ledgerRows as $l): ?>
            <tr>
              <td>
                <?php
                  $tgl = !empty($l->TanggalBayar) ? $l->TanggalBayar : (!empty($l->CreatedAt) ? $l->CreatedAt : null);
                  echo $tgl ? date('Y-m-d H:i', strtotime($tgl)) : '-';
                ?>
              </td>
              <td><?= htmlspecialchars($l->Jenis ?? $l->JenisPembayaran ?? '-'); ?></td>
              <td>Rp <?= number_format((float)($l->Nominal ?? 0),0,',','.'); ?></td>
              <td>
                <?php if (!empty($l->BuktiTransfer)): ?>
                  <a href="<?= base_url('uploads/bukti_transfer/'.$l->BuktiTransfer); ?>" target="_blank">Lihat</a>
                <?php else: ?>
                  -
                <?php endif; ?>
              </td>
            </tr>
          <?php endforeach; ?>
        <?php else: ?>
          <tr><td colspan="4" class="text-center text-muted">Belum ada ledger.</td></tr>
        <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>

</div>

<?php $this->load->view('templates/footer'); ?>