<?php $this->load->view('templates/header'); ?>
<?php $this->load->view('templates/sidebar'); ?>
<?php $this->load->view('templates/topbar'); ?>

<div class="container mt-4">
    <h3 class="mb-4"><?= $title; ?></h3>

    <!-- Info Tagihan -->
    <div class="alert alert-info">
        <strong>Total Biaya:</strong> Rp <?= number_format($total_biaya,0,',','.'); ?><br>
        <strong>Total Dibayar:</strong> Rp <?= number_format($total_bayar,0,',','.'); ?><br>
        <strong>Sisa Tagihan:</strong> Rp <?= number_format($sisa_tagihan,0,',','.'); ?>
    </div>

    <!-- Form Upload Pembayaran -->
    <div class="card mb-4">
        <div class="card-header">Form Pembayaran Raftel</div>
        <div class="card-body">
            <?= form_open_multipart('pembayaran_raftel/submit'); ?>
                <div class="form-group">
                    <label for="JumlahBayar">Jumlah Bayar</label>
                    <input type="number" class="form-control" name="JumlahBayar" required>
                </div>
                <div class="form-group">
                    <label for="MetodeBayar">Metode Bayar</label>
                    <select class="form-control" name="MetodeBayar" required>
                        <option value="Transfer Bank">Transfer Bank</option>
                        <option value="Cash">Cash</option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="BuktiTransfer">Bukti Transfer</label>
                    <input type="file" class="form-control" name="BuktiTransfer">
                </div>
                <button type="submit" class="btn btn-primary">Kirim Pembayaran</button>
            <?= form_close(); ?>
        </div>
    </div>

    <!-- Riwayat Pembayaran -->
    <div class="card">
        <div class="card-header">Riwayat Pembayaran Raftel</div>
        <div class="card-body">
            <?php if (empty($riwayat)): ?>
                <p class="text-muted">Belum ada pembayaran raftel yang dicatat.</p>
            <?php else: ?>
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>Tanggal</th>
                            <th>Jumlah</th>
                            <th>Metode</th>
                            <th>Status</th>
                            <th>Bukti</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($riwayat as $r): ?>
                            <tr>
                                <td><?= !empty($r->TanggalBayar) ? date('d-m-Y H:i', strtotime($r->TanggalBayar)) : '-' ?></td>
                                <td><?= $r->JumlahBayar ? 'Rp '.number_format($r->JumlahBayar,0,',','.') : '-' ?></td>
                                <td><?= $r->MetodeBayar ?? '-' ?></td>
                                <td>
                                    <?php if ($r->StatusBayar == 'Approved'): ?>
                                        <span class="badge badge-success">Approved</span>
                                    <?php elseif ($r->StatusBayar == 'Rejected'): ?>
                                        <span class="badge badge-danger">Rejected</span>
                                    <?php else: ?>
                                        <span class="badge badge-warning">Pending</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if (!empty($r->BuktiTransfer)): ?>
                                        <a href="<?= base_url('uploads/bukti_transfer/'.$r->BuktiTransfer); ?>" target="_blank">Lihat</a>
                                    <?php else: ?>
                                        -
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php $this->load->view('templates/footer'); ?>
