<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Pdf extends CI_Controller {

	function __construct(){
		parent::__construct();		
		$this->load->model('Model_mold');
		

		if (!isset($_SESSION['nama'])){
			session_start();
			$this->session->set_flashdata('message', 'Anda harus login dulu!');
			redirect('login');
		}

	}
	
	public function cetak_pdf()
{
    $this->load->library('pdfgenerator');

    // Ambil filter dari query string
    $start_date = $this->input->get('start_date');
    $end_date   = $this->input->get('end_date');

    // Ambil data sesuai filter
    $data['mold'] = $this->Model_mold->get_filtered($start_date, $end_date);
    $data['title']   = 'Laporan PDF';

    // Render view ke HTML
    $html = $this->load->view('mold/pdf', $data, true);

    // Cetak PDF
    $this->pdfgenerator->generate($html, 'get_filtered', 'A4', 'landscape');
}




}

	
/* End of file Pdf.php */
/* Location: ./application/controllers/Pdf.php */