<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Scan extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Model_erpserver');
        $this->load->helper(['url','form']);
        $this->load->library(['session','user_agent']);

        // Guard login
        if (!$this->session->userdata('nama')) {
            $this->session->set_flashdata('error', 'Anda harus login dulu!');
            redirect('login');
        }
    }

    /* ------------ TEMPLATE RENDER ------------ */
    private function render($view, $data = [])
    {
        // $data['title'] opsional
        $this->load->view('templates/header', $data);
        $this->load->view('templates/sidebar', $data);
        $this->load->view('templates/content_start', $data); // open topbar + container
        $this->load->view($view, $data);                      // pure content
        $this->load->view('templates/footer');                // close container + wrapper
    }

    /* ------------ INDEX ------------ */
    public function index()
    {
        $from      = $this->input->get('from');
        $to        = $this->input->get('to');
        $sj_number = $this->input->get('sj_number');

        $data = [
            'title'         => 'Verifikasi Surat Jalan',
            'selected_from' => $from,
            'selected_to'   => $to,
            'sj_number'     => $sj_number,
            'sj_list'       => ($from && $to) ? $this->Model_erpserver->get_sj_by_date_range($from, $to) : [],
            'sj_data'       => $sj_number ? $this->Model_erpserver->get_sj_detail($sj_number) : [],
            'nama_pic'      => $this->session->userdata('nama_pic'),
            'scan_complete' => $this->session->flashdata('scan_complete'),
        ];

        $this->render('scansj/scan_page', $data);
    }

    /* ------------ SUBMIT SCAN ------------ */
    public function submit_scan()
    {
        $qr    = $this->input->post('product_code');
        $sj    = $this->input->post('sj_number');
        $from  = $this->input->post('from');
        $to    = $this->input->post('to');
        $pic   = $this->session->userdata('nama_pic') ?: $this->session->userdata('nama');

        $parsed = $this->_parse_qr($qr);
        if (!$parsed) return $this->_fail('Format QR tidak valid');

        [$code, $name, $qty, $shift, $seq] = $parsed;

        $row = $this->Model_erpserver->get_detail_sj($sj, $code);
        if (!$row) return $this->_fail('Produk tidak ditemukan di Surat Jalan');

        if ($this->Model_erpserver->is_duplicate_sequence($sj, $code, $shift, $seq)) {
            return $this->_fail('Label sudah pernah discan.');
        }

        $scanned_total = $this->Model_erpserver->get_total_scanned($sj, $code);
        if (($scanned_total + $qty) > $row->SJ_qty) {
            return $this->_fail('Qty scan melebihi jumlah SJ.');
        }

        $this->Model_erpserver->save_scan_to_erp([
            'sj_number'    => $sj,
            'product_code' => $code,
            'scan_qty'     => $qty,
            'sequence'     => $seq,
            'shift'        => $shift,
            'scanned_by'   => $pic,
            'scanned_at'   => date('Y-m-d H:i:s'),
        ]);

        $this->session->set_flashdata('last_scanned_code', $code);

        // Cek complete
        $all = $this->Model_erpserver->get_sj_detail($sj);
        $complete = true;
        foreach ($all as $item) {
            if ($item->scanned_qty < $item->SJ_qty) { $complete = false; break; }
        }

        if ($complete) {
            $this->session->set_flashdata('scan_complete', true);
            $this->session->set_flashdata('scan_status', 'SELESAI');
        } else {
            $this->session->set_flashdata('scan_success', 'Scan berhasil');
        }

        $qs = http_build_query(['from'=>$from,'to'=>$to,'sj_number'=>$sj]);
        redirect('scan?'.$qs);
    }

    /* ------------ RESET SCAN ------------ */
    public function reset_scan($sj_number)
    {
        $this->Model_erpserver->reset_scan_log($sj_number);
        $this->session->set_flashdata('scan_success', "Scan untuk SJ $sj_number telah di-reset.");
        $qs = http_build_query(['sj_number'=>$sj_number]);
        redirect('scan?'.$qs);
    }

    /* ------------ Trigger Notifikasi Manual (opsional) ------------ */
    public function trigger_complete()
    {
        $sj_number = $this->input->get('sj_number');
        $from      = $this->input->get('from');
        $to        = $this->input->get('to');

        $details = $this->Model_erpserver->get_sj_detail($sj_number);
        if (!$details || count($details) === 0) {
            $this->session->set_flashdata('scan_error', 'Data SJ tidak ditemukan.');
            $qs = http_build_query(['from'=>$from,'to'=>$to,'sj_number'=>$sj_number]);
            redirect('scan?'.$qs); return;
        }

        $is_complete = true;
        $has_scan    = false;

        foreach ($details as $row) {
            if ($row->scanned_qty > 0) $has_scan = true;
            if ($row->scanned_qty < $row->SJ_qty) $is_complete = false;
        }

        if (!$has_scan) {
            $this->session->set_flashdata('scan_status', 'BELUM ADA YANG DISCAN');
        } elseif ($is_complete) {
            $this->session->set_flashdata('scan_status', 'SELESAI');
        } else {
            $this->session->set_flashdata('scan_status', 'BELUM LENGKAP');
        }

        $qs = http_build_query(['from'=>$from,'to'=>$to,'sj_number'=>$sj_number]);
        redirect('scan?'.$qs);
    }

    /* ------------ Helpers ------------ */
    private function _parse_qr($qr)
    {
        $parts = explode('/', $qr);
        if (count($parts) < 7) return false;

        $code  = $parts[0];
        $name  = $parts[1];
        $qty   = (int) str_replace(',', '', trim($parts[2]));
        $shift = $parts[5];
        $seq   = $parts[6];

        return [$code, $name, $qty, $shift, $seq];
    }

    private function _fail($msg)
    {
        $this->session->set_flashdata('scan_error', $msg);
        $ref = $this->agent->referrer() ?: site_url('scan');
        redirect($ref);
    }
}
