<?php
defined('BASEPATH') OR exit('No direct script access allowed');

// Autoload Dompdf manual
require_once(APPPATH . 'libraries/dompdf/autoload.inc.php');

use Dompdf\Dompdf;
use Dompdf\Options;

class Pdfgenerator
{
    /**
     * @param string $html        HTML siap cetak
     * @param string $filename    Nama file tanpa .pdf
     * @param string $paper       A4|A5|Letter|...
     * @param string $orientation portrait|landscape
     * @param bool   $download    true=download, false=inline preview
     */
    public function generate($html, $filename = 'document', $paper = 'A4', $orientation = 'portrait', $download = false)
    {
        // Opsi yang lebih lengkap & aman
        $options = new Options();
        $options->set('isRemoteEnabled', true);         // allow remote assets (jika perlu)
        $options->set('isHtml5ParserEnabled', true);
        $options->set('defaultFont', 'DejaVu Sans');    // font aman untuk IDN
        $options->set('dpi', 96);
        // batasi akses file ke root app
        $options->setChroot(FCPATH);

        $dompdf = new Dompdf($options);
        $dompdf->setPaper($paper, $orientation);
        $dompdf->loadHtml($html, 'UTF-8');
        $dompdf->render();

        // Inline preview by default; set $download=true untuk paksa unduh
        $dompdf->stream($filename . '.pdf', ['Attachment' => $download]);
    }
}
