<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Model_erpserver extends CI_Model {

    private $erp;

    public function __construct()
    {
        parent::__construct();
        // Load koneksi database ERP
        $this->erp = $this->load->database('erpserver', TRUE);
    }

    /**
     * Ambil daftar surat jalan berdasarkan rentang tanggal
     */
    public function get_sj_by_date_range($from, $to)
    {
        return $this->erp
            ->where('SJ_date >=', $from)
            ->where('SJ_date <=', $to)
            ->get('tSuratJalan_h')
            ->result();
    }

    /**
     * Ambil detail surat jalan lengkap dengan nama produk dan total hasil scan
     */
    public function get_sj_detail($sj_number)
{
    // Ambil detail SJ
    $details = $this->erp
        ->select('
            d.Product_code, 
            p.Product_name, 
            SUM(d.SJ_qty) AS SJ_qty
        ')
        ->from('tSuratJalan_d d')
        ->join('mProduct p', 'd.Product_code = p.Product_code', 'left')
        ->where('d.SJ_number', $sj_number)
        ->group_by('d.Product_code, p.Product_name')
        ->get()
        ->result();

    // Ambil total scanned per product
    $scans = $this->erp
        ->select('Product_code, SUM(scan_qty) AS scanned_qty')
        ->from('tScanLog')
        ->where('SJ_number', $sj_number)
        ->group_by('Product_code')
        ->get()
        ->result();

    // Indexing hasil scan
    $scan_map = [];
    foreach ($scans as $s) {
        $scan_map[$s->Product_code] = $s->scanned_qty;
    }

    // Gabungkan hasilnya
    foreach ($details as $d) {
        $d->scanned_qty = $scan_map[$d->Product_code] ?? 0;
    }

    return $details;
}

    /**
     * Ambil satu detail produk dari SJ tertentu
     */
    public function get_detail_sj($sj_number, $product_code)
{
    return $this->erp
        ->select('Product_code, SUM(SJ_qty) as SJ_qty')
        ->where('SJ_number', $sj_number)
        ->where('Product_code', $product_code)
        ->group_by('Product_code')
        ->get('tSuratJalan_d')
        ->row();
}

    /**
     * Cek apakah sequence + shift sudah pernah discan (untuk hindari duplikat)
     */
    public function is_duplicate_sequence($sj_number, $product_code, $shift, $sequence)
{
    $this->erp->where('SJ_number', $sj_number);
    $this->erp->where('Product_code', $product_code);
    $this->erp->where('shift', $shift);
    $this->erp->where('sequence', $sequence);
    $query = $this->erp->get('tScanLog');

    return $query && $query->num_rows() > 0;
}


    /**
     * Ambil total qty yang sudah discan untuk produk tertentu
     */
    public function get_total_scanned($sj_number, $product_code)
{
    $result = $this->erp
        ->select_sum('scan_qty')
        ->where('SJ_number', $sj_number)
        ->where('Product_code', $product_code)
        ->get('tScanLog')
        ->row();

    return $result->scan_qty ?? 0;
}


    /**
     * Simpan data hasil scan ke tabel tScanLog
     */
    public function save_scan_to_erp($data)
    {
        return $this->erp->insert('tScanLog', [
            'SJ_number'    => $data['sj_number'],
            'Product_code' => $data['product_code'],
            'scan_qty'     => $data['scan_qty'],
            'sequence'     => $data['sequence'],
            'shift'        => $data['shift'],
            'scanned_by'   => $data['scanned_by'],
            'scanned_at'   => $data['scanned_at'],
        ]);
    }

    /**
     * Hapus semua data scan berdasarkan nomor SJ
     */
    public function reset_scan_log($sj_number)
    {
        return $this->erp
            ->where('SJ_number', $sj_number)
            ->delete('tScanLog');
    }
}
