<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Model_mold extends CI_Model
{
    private $table = 'tb_mold';

    /**
     * Ambil semua data mold
     */
    public function get_all(){
        return $this->db->get($this->table)->result();
    }

    /**
     * Ambil data mold berdasarkan ID
     */
    public function get_by_id($id){
        return $this->db->get_where($this->table, ['id' => $id])->row();
    }

    // update berdasarkan baris yang di pilih
    public function get_by_part_number_except_id($part_number, $id = null) {
    $this->db->where('part_number', $part_number);
    if ($id !== null) {
        $this->db->where('id !=', $id); // Hindari baris yg sedang di-edit
    }
    return $this->db->get($this->table)->row();
    }

    /**
     * Simpan data mold baru
     */
    public function insert($data){
        return $this->db->insert($this->table, $data);
    }

    /**
     * Update data mold berdasarkan ID
     */
    public function update($id, $data){
        return $this->db->update($this->table, $data, ['id' => $id]);
    }

    /**
     * Hapus data mold berdasarkan ID
     */
    public function delete($id){
        return $this->db->delete($this->table, ['id' => $id]);
    }

    /**
     * Ambil data berdasarkan filter pencarian
     */
    public function get_filtered($filters = []){
        if (!empty($filters['part_number'])) {
            $this->db->like('part_number', $filters['part_number']);
        }

        if (!empty($filters['customer'])) {
            $this->db->like('customer', $filters['customer']);
        }

        if (!empty($filters['machine_type'])) {
            $this->db->where('machine_type', $filters['machine_type']);
        }
        if (!empty($filters['tgl_awal']) && !empty($filters['tgl_akhir'])) {
        $this->db->where('date >=', $filters['tgl_awal']);
        $this->db->where('date <=', $filters['tgl_akhir']);
        } elseif (!empty($filters['tgl_awal'])) {
        $this->db->where('date >=', $filters['tgl_awal']);
        } elseif (!empty($filters['tgl_akhir'])) {
        $this->db->where('date <=', $filters['tgl_akhir']);
        }

        $query = $this->db->get($this->table);
        return $query ? $query->result() : [];
    }

    /**
     * Ambil daftar machine_type unik untuk dropdown filter
     */
   public function get_unique_machine_types(){
    $this->db->distinct();
    $this->db->select('machine_type');
    $this->db->where('machine_type IS NOT NULL');
    $this->db->where('machine_type !=', '');
    $this->db->order_by('machine_type', 'asc');
    $query = $this->db->get($this->table);
    return $query ? $query->result() : [];
    }

    public function insert_batch($data){
    return $this->db->insert_batch($this->table, $data);
    }

    public function sync_data_stock() {
    // Query update langsung di database (paling efisien)
    $this->db->where('data_stock != qty'); // Hanya update yang belum sama
    $this->db->set('data_stock', 'qty', false); // false = tidak escape field
    $this->db->set('last_update', date('Y-m-d H:i:s'));
    $this->db->update($this->table);

    return $this->db->affected_rows(); // Return jumlah data yang diupdate
    }
}
