<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Piket_daily_model extends CI_Model
{
    /* ==========================
     * LIST / GET
     * ========================== */

    /** List header untuk index */
    public function get_list($limit = 200, $offset = 0)
    {
        return $this->db->order_by('dibuat_pada', 'DESC')
                        ->limit($limit, $offset)
                        ->get('piket_daily')
                        ->result();
    }

    /** Ambil header by id */
    public function get_header($id)
    {
        return $this->db->get_where('piket_daily', ['id' => (int)$id])->row();
    }

    /** Ambil semua lines by piket_id (urut rapi) */
    public function get_lines($piket_id)
    {
        return $this->db->order_by('urutan ASC, id ASC')
                        ->get_where('piket_daily_lines', ['piket_id' => (int)$piket_id])
                        ->result();
    }

    /** Ambil semua foto by piket_id (opsional dipakai saat print) */
    public function get_photos($piket_id)
    {
        return $this->db->order_by('urutan ASC, id ASC')
                        ->get_where('piket_daily_photos', ['piket_id' => (int)$piket_id])
                        ->result();
    }

    /* ==========================
     * INSERT
     * ========================== */

    /** Insert header dan kembalikan insert_id */
    public function create_header(array $data)
    {
        $this->db->insert('piket_daily', $data);
        return (int) $this->db->insert_id();
    }

    /** Insert satu baris line */
    public function insert_line($piket_id, array $row)
    {
        $row['piket_id'] = (int)$piket_id;
        $this->db->insert('piket_daily_lines', $row);
        return (int) $this->db->insert_id();
    }

    /** Insert foto (satu record) */
    public function insert_photo($piket_id, $file_path, $caption = null, $urutan = 0, $line_index = null)
    {
        $data = [
            'piket_id'  => (int)$piket_id,
            'file_path' => $file_path,
            'caption'   => $caption,
            'urutan'    => (int)$urutan,
        ];
        if ($this->db->field_exists('line_index', 'piket_daily_photos')) {
            $data['line_index'] = is_null($line_index) ? null : (int)$line_index;
        }
        $this->db->insert('piket_daily_photos', $data);
        return (int) $this->db->insert_id();
    }

    /** Seed default lines (dipakai sekali saat editor kosong) */
    public function seed_default_lines($piket_id)
    {
        $exists = $this->db->where('piket_id', (int)$piket_id)
                           ->count_all_results('piket_daily_lines');
        if ($exists) return 0;

        $rows = [
            ['section'=>'PRODUCTION (Vacuum, Press, DHC)','time_slot'=>null,'urutan'=>10],
            ['section'=>'DELIVERY','time_slot'=>null,'urutan'=>20],
            ['section'=>'SAFETY','time_slot'=>null,'urutan'=>30],
            ['section'=>'CHECK POINT KONDISI PINTU ANTISIPASI SERANGGA','time_slot'=>'Jam 17.00 - 19.00 wib','urutan'=>40],
            ['section'=>null,'time_slot'=>'Jam 19.00 - 20.00 wib','urutan'=>41],
            ['section'=>null,'time_slot'=>'Jam 20.00 wib - dst','urutan'=>42],
            ['section'=>'S-S','time_slot'=>null,'urutan'=>50],
            ['section'=>'SAVING ENERGY (A/C, Lamp, M/C)','time_slot'=>null,'urutan'=>60],
        ];

        foreach ($rows as &$r) { $r['piket_id'] = (int)$piket_id; }
        $this->db->insert_batch('piket_daily_lines', $rows);
        return $this->db->affected_rows();
    }

    /* ==========================
     * UPDATE
     * ========================== */

    /** Update header */
    public function update_header($id, array $data)
    {
        return $this->db->where('id', (int)$id)
                        ->update('piket_daily', $data);
    }

    /** Update 1 field di line (dipakai AJAX inline editor) */
    public function update_line_field($line_id, $field, $value, $user_id = null)
    {
        if (!in_array($field, ['description','issue','remarks','is_issue','urutan'], true)) {
            return false;
        }
        $data = [
            $field       => $value,
            'updated_at' => date('Y-m-d H:i:s'),
        ];
        if (!is_null($user_id)) $data['updated_by'] = (int)$user_id;

        return $this->db->where('id', (int)$line_id)
                        ->update('piket_daily_lines', $data);
    }

    /* ==========================
     * DELETE (cascade)
     * ========================== */

    /** Hapus satu header dan seluruh turunannya */
    public function delete_all($id)
    {
        $id = (int)$id;

        $this->db->trans_start();

        // hapus file fisik foto
        $photos = $this->db->get_where('piket_daily_photos', ['piket_id'=>$id])->result();
        foreach ($photos as $p) {
            $path = FCPATH.$p->file_path;
            if (is_file($path)) @unlink($path);
        }

        // hapus DB
        $this->db->delete('piket_daily_photos', ['piket_id'=>$id]);
        $this->db->delete('piket_daily_lines',  ['piket_id'=>$id]);
        $this->db->delete('piket_daily',        ['id'=>$id]);

        $this->db->trans_complete();
        return $this->db->trans_status();
    }
}
