<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Piket_signature_model extends CI_Model
{
    private $tbl        = 'piket_daily_signatures';
    private $rights_tbl = 'piket_signature_rights';

    // application/models/Piket_signature_model.php
public function get_by_report($piket_id) {
    $rows = $this->db->get_where($this->tbl, ['piket_id' => (int)$piket_id])->result();
    $out = ['PIC'=>null,'CHECK'=>null,'CONFIRM'=>null,'APPROVE'=>null];
    foreach ($rows as $r) {
        $key = strtoupper((string)($r->role ?? $r->slot_role ?? ''));
        if (isset($out[$key])) $out[$key] = $r;
    }
    return $out;
}


    /** Hak tanda tangan user (tabel rights masih pakai slot_role, biarkan) */
    public function get_rights_by_user($user_id) {
        return $this->db->select('slot_role')
                        ->get_where($this->rights_tbl, ['user_id' => (int)$user_id])
                        ->result_array();
    }

    /** Cek user berhak sign slot tertentu */
    public function can_sign($user_id, $slot_role) {
        return (bool) $this->db->where([
                    'user_id'   => (int)$user_id,
                    'slot_role' => strtoupper($slot_role)
                ])->count_all_results($this->rights_tbl);
    }

    /** Upsert signature 1 slot (pakai kolom role) */
    public function upsert($piket_id, $slot_role, $user_id, $image_path, $extra = [])
    {
        $now = date('Y-m-d H:i:s');
        $slot_role = strtoupper($slot_role);

        $exists = $this->db->get_where($this->tbl, [
                        'piket_id' => (int)$piket_id,
                        'role'     => $slot_role
                  ])->row();

        $data = array_merge([
            'piket_id'   => (int)$piket_id,
            'role'       => $slot_role,
            'user_id'    => (int)$user_id,
            'image_path' => $image_path,
            'signed_at'  => $now,
        ], $extra);

        if ($exists) {
            $this->db->where('id', $exists->id)->update($this->tbl, $data);
            return $exists->id;
        } else {
            $this->db->insert($this->tbl, $data);
            return $this->db->insert_id();
        }
    }

    /** Hapus signature slot tertentu */
    public function delete_slot($piket_id, $slot_role) {
        return $this->db->delete($this->tbl, [
            'piket_id' => (int)$piket_id,
            'role'     => strtoupper($slot_role)
        ]);
    }

    /** Status ringkas utk badge */
    public function get_status_summary($piket_id) {
        $rows = $this->db->select('role, user_id, signed_at')
                         ->get_where($this->tbl, ['piket_id' => (int)$piket_id])
                         ->result();

        $out = ['PIC'=>null,'CHECK'=>null,'CONFIRM'=>null,'APPROVE'=>null];
        foreach ($rows as $r){
            $key = strtoupper((string)$r->role);
            if (isset($out[$key])) $out[$key] = $r;
        }
        return $out;
    }
}
