<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<?php
if (!function_exists('esc')) { function esc($s){ return htmlspecialchars((string)($s ?? ''), ENT_QUOTES, 'UTF-8'); } }

$today       = date('Y-m-d');
$dw          = (int)date('w', strtotime($today)); // 0=Min..6=Sab
$namaDefault = (string)($this->session->userdata('nama') ?: '');
?>
<style>
  .piket-card{background:#fff;border:1px solid #e7eef5;border-radius:10px;box-shadow:0 2px 10px rgba(0,0,0,.03)}
  .grid table{width:100%;border-collapse:collapse}
  .grid th,.grid td{border:1px solid #dde5ee;padding:12px;vertical-align:top}
  .grid th{background:#f8fafc;font-weight:600;color:#405b74}

  /* chip upload: 3 kolom fix */
  .chip-grid{display:grid;grid-template-columns:repeat(3,minmax(160px,1fr));gap:.75rem}
  @media (max-width: 768px){ .chip-grid{grid-template-columns:repeat(2,minmax(150px,1fr))} }
  @media (max-width: 480px){ .chip-grid{grid-template-columns:1fr} }

  .chip{position:relative;display:flex;align-items:center;gap:.6rem;padding:.6rem .85rem;
        border:1px dashed #b8e3c1;border-radius:14px;background:#f2fff5}
  .chip .icon{width:28px;height:28px;border-radius:50%;background:#22c55e;color:#fff;
              display:flex;align-items:center;justify-content:center;font-weight:700}
  .chip strong{display:block;line-height:1;color:#124b2e}
  .chip small{display:block;line-height:1.1;color:#3c6e4f}
  .chip input[type=file]{position:absolute;inset:0;opacity:0;cursor:pointer}

  .slot-note{font-size:12px;color:#6b7280;margin-top:.35rem}
</style>

<h1 class="h3 mb-3 text-gray-800">Entry Piket Daily</h1>

<?php if ($msg = $this->session->flashdata('piket_error')): ?>
  <div class="alert alert-danger"><?= esc($msg) ?></div>
<?php endif; ?>
<?php if ($msg = $this->session->flashdata('piket_success')): ?>
  <div class="alert alert-success"><?= esc($msg) ?></div>
<?php endif; ?>

<form action="<?= site_url('piket-daily/store'); ?>" method="post" enctype="multipart/form-data">
  <!-- Header -->
  <div class="piket-card mb-3">
    <div class="card-body">
      <div class="row g-3">
        <div class="col-md-3">
          <label class="form-label">Tanggal <span class="text-danger">*</span></label>
          <input type="date" name="tanggal" id="tanggal" class="form-control" value="<?= esc($today) ?>" required>
          <small id="jamHelp" class="text-muted d-block">Minggu tidak diizinkan.</small>
        </div>
        <div class="col-md-5">
          <label class="form-label">Nama Pengisi <span class="text-danger">*</span></label>
          <input type="text" name="nama_pengisi" class="form-control" value="<?= esc($namaDefault) ?>" required>
        </div>
        <div class="col-md-4">
          <label class="form-label">Jam <span class="text-danger">*</span></label>
          <select name="jam_header" id="jam_header" class="form-control" required></select>
        </div>
      </div>
    </div>
  </div>

  <!-- Hidden legacy (biar lolos rules lama di controller) -->
  <input type="hidden" name="shift" value="PAGI">
  <input type="hidden" name="lokasi" value="N/A">
  <input type="hidden" name="deskripsi" value="">

  <!-- Grid -->
  <div class="piket-card grid">
    <div class="card-header py-2">
      <strong>DAILY LAPORAN PIKET</strong>
      <small class="text-muted d-block">
        Isi kolom <em>Issue</em>. Kolom <em>Remarks</em> = upload foto (maks 3 file / baris). Server otomatis kompres ≤ 1MB & paksa landscape.
      </small>
    </div>

    <div class="card-body p-0">
      <div class="table-responsive">
        <table class="table mb-0">
          <thead class="table-light text-center">
            <tr>
              <th style="width:28%">DESCRIPTION</th>
              <th style="width:42%">ISSUE</th>
              <th style="width:30%">REMARKS (PHOTOS)</th>
            </tr>
          </thead>
          <tbody>
          <?php
            // === Rows: PRODUCTION dipecah 3 baris (Vacuum, Press, DHC) ===
            $rows = [
              ['section'=>'PRODUCTION (Vacuum)','slot'=>null],
              ['section'=>'PRODUCTION (Press)','slot'=>null],
              ['section'=>'PRODUCTION (DHC)','slot'=>null],

              ['section'=>'DELIVERY','slot'=>null],
              ['section'=>'SAFETY','slot'=>null],

              ['section'=>'CHECK POINT KONDISI PINTU ANTISIPASI SERANGGA','slot'=>'Jam 17.00 - 19.00 wib'],
              ['section'=>null,'slot'=>'Jam 19.00 - 20.00 wib'],
              ['section'=>null,'slot'=>'Jam 20.00 wib - dst'],

              ['section'=>'5-S','slot'=>null],
              ['section'=>'SAVING ENERGY (A/C, Lamp, M/C)','slot'=>null],
              ['section'=>'ABSENSI & AKTIVITAS KARYAWAN','slot'=>null],
            ];
            foreach ($rows as $i => $r):
              $section = $r['section'] ?? '';
              $slot    = $r['slot'] ?? '';
          ?>
            <tr>
              <td>
                <?php if ($section !== ''): ?><div class="fw-bold"><?= esc($section) ?></div><?php endif; ?>
                <?php if ($slot !== ''): ?><small class="text-muted"><?= esc($slot) ?></small><?php endif; ?>
                <input type="hidden" name="lines[<?= $i ?>][section]"   value="<?= esc($section) ?>">
                <input type="hidden" name="lines[<?= $i ?>][time_slot]" value="<?= esc($slot) ?>">
              </td>
              <td>
                <textarea name="lines[<?= $i ?>][issue]" rows="4" class="form-control" placeholder="Tulis issue di sini..."></textarea>
              </td>
              <td>
                <!-- Tiga input, satu file per slot — nama sama => line_photos_{i}[]  -->
                <div class="chip-grid">
                  <?php for ($s=1; $s<=3; $s++): ?>
                    <label class="chip" title="Klik untuk pilih foto">
                      <span class="icon">📷</span>
                      <div>
                        <strong>Foto <?= $s ?></strong>
                        <small>≤1MB, landscape</small>
                      </div>
                      <input type="file" name="line_photos_<?= $i ?>[]" accept=".jpg,.jpeg,.png">
                    </label>
                  <?php endfor; ?>
                </div>
                <div class="slot-note">Maks 3 foto per baris.</div>
              </td>
            </tr>
          <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>

    <div class="card-footer d-flex align-items-center" style="gap:.5rem">
      <button class="btn btn-primary">Simpan</button>

      <?php if ($pid = $this->session->flashdata('piket_saved_id')): ?>
        <a class="btn btn-outline-secondary" href="<?= site_url('piket-daily/print/'.esc($pid)) ?>" target="_blank" rel="noopener">Print A4</a>
      <?php else: ?>
        <button class="btn btn-outline-secondary" type="button" disabled title="Simpan dulu untuk mengaktifkan">Print A4</button>
      <?php endif; ?>

      <?php if ($pid = $this->session->flashdata('piket_saved_id')): ?>
  <a class="btn btn-success"
     href="<?= site_url('piket-daily/sign_pad/'.$pid.'/PIC') ?>">
     Tanda Tangan PIC
  </a>
<?php else: ?>
  <button class="btn btn-success" type="button" disabled title="Simpan dulu untuk mengaktifkan">
    Tanda Tangan PIC
  </button>
<?php endif; ?>

      
      <a class="btn btn-secondary" href="<?= site_url('piket-daily'); ?>">Batal</a>


    </div>
  </div>
</form>

<script>
(function(){
  const tanggalEl = document.getElementById('tanggal');
  const jamSel    = document.getElementById('jam_header');
  const help      = document.getElementById('jamHelp');
  const OPT_WD = '17.00 - 23.00', OPT_SAT = '12.00 - 17.00';

  function setJamOptions(ymd){
    jamSel.innerHTML = '';
    if(!ymd) return;
    const d = new Date(ymd + 'T00:00:00');
    const dow = d.getDay(); // 0..6
    if (dow === 0){
      jamSel.disabled = true;
      help.classList.replace('text-muted','text-danger');
      help.textContent = 'Minggu tidak diizinkan.';
      return;
    }
    jamSel.disabled = false;
    help.classList.replace('text-danger','text-muted');
    help.textContent = (dow===6) ? ('Sabtu: jam wajib '+OPT_SAT) : ('Senin–Jumat: jam wajib '+OPT_WD);

    const val = (dow===6) ? OPT_SAT : OPT_WD;
    const opt = document.createElement('option'); opt.value = val; opt.textContent = val;
    jamSel.appendChild(opt);
  }

  setJamOptions(tanggalEl.value);
  tanggalEl.addEventListener('change', e => setJamOptions(e.target.value));

  // feedback kecil: tandai chip saat ada file
  document.querySelectorAll('input[type=file]').forEach(inp=>{
    inp.addEventListener('change', e=>{
      if (e.target.files && e.target.files[0]) {
        const chip = e.target.closest('.chip');
        chip.style.border = '1px solid #22c55e';
        const strong = chip.querySelector('strong');
        if (!strong.textContent.endsWith('✓')) strong.textContent += ' ✓';
      }
    });
  });
})();
</script>
